package com.biz.eisp.base.interfacedao.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;

import org.apache.log4j.Logger;

import com.biz.eisp.base.interfacedao.annotation.Param;

/**
 * InterfaceDao 工具类方法
 * @author Sean
 */
public class InterfaceDaoUtil {
	
	private static final Logger logger = Logger.getLogger(InterfaceDaoUtil.class);
	
	 // 数据库类型
	public static final String DATABSE_TYPE_MYSQL = "mysql";
	public static final String DATABSE_TYPE_ORACLE = "oracle";
	
	// mysql 分页SQL
	public static final String MYSQL_SQL = "select * from ( {0}) sel_tab00 limit {1},{2}"; 
	// oracle 分页SQL
	public static final String ORACLE_SQL = "select * from (select row_.*,rownum "
			+ "rownum_ from ({0}) row_ where rownum <= {1}) where rownum_>{2}"; 

	

	/**
	 * 按照数据库类型，封装分页查询SQL
	 * @param dbType 数据库类型
	 * @param sql
	 * @param page
	 * @param rows
	 * @return
	 */
	public static String createPageSql(String dbType, String sql, int page,int rows) {
		String[] sqlParam = new String[3];
		sqlParam[0] = sql;
		
		String jdbcType = dbType;
		if (jdbcType == null || "".equals(jdbcType)) {
			throw new RuntimeException(
					"InterfaceDaoHandler:(数据库类型:dbType)没有设置,请检查配置文件");
		}
		
		if (jdbcType.indexOf(DATABSE_TYPE_MYSQL) != -1) {
			sqlParam[1] = page + "";
			sqlParam[2] = rows + "";
			sql = MessageFormat.format(MYSQL_SQL, sqlParam);
		} else if (jdbcType.indexOf(DATABSE_TYPE_ORACLE) != -1) {
			int endIndex = page + rows;
			sqlParam[1] = Integer.toString(endIndex);
			sqlParam[2] = Integer.toString(page);
			sql = MessageFormat.format(ORACLE_SQL, sqlParam);
		}
		
		return sql;
	}
	
	/**
	 * 获取指定方法的参数名
	 * @param method
	 *            要获取参数名的方法
	 * @return 按参数顺序排列的参数名列表
	 */
	public static String[] getMethodParameterNamesByAnnotation(Method method) {
		
		Annotation[][] parameterAnnotations=method.getParameterAnnotations();
		if(parameterAnnotations==null||parameterAnnotations.length==0){
			return null;
		}
		
		String[] parameterNames = new String[parameterAnnotations.length];
		int i = 0;
		for(Annotation[] parameterAnnotation:parameterAnnotations){
			for(Annotation annotation:parameterAnnotation){
				if(annotation instanceof Param){
					Param param = (Param) annotation;
					parameterNames[i++]=param.value();
				}
			}
		}
		return parameterNames;
	}

	private static int getAfterSelectInsertPoint(String sql) {
		int selectIndex = sql.toLowerCase().indexOf("select");
		int selectDistinctIndex = sql.toLowerCase().indexOf("select distinct");
		return selectIndex + (selectDistinctIndex == selectIndex ? 15 : 6);
	}

	/**
	 * 返回首字母变为小写的字符串
	 * 
	 * @param name
	 * @return
	 */
	public static String getFirstSmall(String name) {
		name = name.trim();
		if (name.length() >= 2) {
			return name.substring(0, 1).toLowerCase() + name.substring(1);
		} else {
			return name.toLowerCase();
		}

	}

	/**
	 * 根据SQL_URL读取SQL文件内容
	 * 
	 * @param sqlurl
	 * @return
	 */
	public static String getMethodSqlLogicJar(String sqlurl) {
		StringBuffer sb = new StringBuffer();
		// 返回读取指定资源的输入流
		InputStream is = InterfaceDaoUtil.class.getResourceAsStream(sqlurl);
		BufferedReader br = new BufferedReader(new InputStreamReader(is));
		String s = "";
		try {
			while ((s = br.readLine()) != null)
				sb.append(s + " ");
		} catch (IOException e) {
			e.printStackTrace();
		}
		return sb.toString();
	}

	/**
	 * 判断方法是否是抽象方法
	 * 
	 * @param method
	 * @return
	 */
	public static boolean isAbstract(Method method) {
		int mod = method.getModifiers();
		return Modifier.isAbstract(mod);
	}

	/**
	 * 判断Class是否是基本包装类型
	 * 
	 * @param clz
	 * @return
	 */
	public static boolean isWrapClass(Class<?> clz) {
		try {
			return ((Class<?>) clz.getField("TYPE").get(null)).isPrimitive();
		} catch (Exception e) {
			return false;
		}
	}

}
