package com.biz.eisp.base.interfacedao.factory;

import java.lang.reflect.Proxy;

import org.springframework.beans.factory.FactoryBean;

import com.biz.eisp.base.interfacedao.aop.InterfaceDaoHandler;

/**
 *  InterfaceDao动态代理的工厂
 * @author Sean
 */
public class InterfaceDaoBeanFactory<T> implements FactoryBean<T> {

	//被代理类
	private Class<T> daoInterface;

	//拦截器代理
	private InterfaceDaoHandler proxy;
	
	@Override
	public T getObject() throws Exception {
		return newInstance();
	}

	@SuppressWarnings("unchecked")
	private T newInstance() {
		return (T) Proxy.newProxyInstance(daoInterface.getClassLoader(), new Class[] { daoInterface }, proxy);
	}
	
	@Override
	public Class<?> getObjectType() {
		return daoInterface;
	}

	@Override
	public boolean isSingleton() {
		return true;
	}

	public Class<T> getDaoInterface() {
		return daoInterface;
	}

	public void setDaoInterface(Class<T> daoInterface) {
		this.daoInterface = daoInterface;
	}

	public InterfaceDaoHandler getProxy() {
		return proxy;
	}

	public void setProxy(InterfaceDaoHandler proxy) {
		this.proxy = proxy;
	}
	
	
}
