package com.biz.eisp.base.interfacedao.factory;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AnnotationTypeFilter;

import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;

/**
 * Dao扫描 
 * 扫描用户配置所需包内的所有Class
 * @author Sean
 */
public class InterfaceDaoClassPathMapperScanner extends ClassPathBeanDefinitionScanner{
	
    private static final Logger logger = Logger.getLogger(InterfaceDaoClassPathMapperScanner.class);
	

	@Override
	protected Set<BeanDefinitionHolder> doScan(String... basePackages) {
		Set<BeanDefinitionHolder> beanDefinitions = super.doScan(basePackages);
		if(beanDefinitions.isEmpty()){
			  logger.warn("Not find InterfaceDao，In package " + Arrays.toString(basePackages) );
		}
	   GenericBeanDefinition definition;
	   for (BeanDefinitionHolder holder : beanDefinitions) {
		   definition = (GenericBeanDefinition) holder.getBeanDefinition();
           definition.getPropertyValues().add("proxy", getRegistry().getBeanDefinition("interfaceDaoHandler"));
           definition.getPropertyValues().add("daoInterface", definition.getBeanClassName());
           //检查此类别是否已启用为信息级别
           if (logger.isInfoEnabled()) {
               logger.info("Have been scanned to  InterfaceDao { " + definition.getBeanClassName().toString() + " }");
           }
           definition.setBeanClass(InterfaceDaoBeanFactory.class);
	   }
		return beanDefinitions;
	}

	public InterfaceDaoClassPathMapperScanner(BeanDefinitionRegistry registry, 
			Class<? extends Annotation> annotation) {
		
        super(registry, false);
        //在包含列表的结尾添加一个包含类型的筛选器
        addIncludeFilter(new AnnotationTypeFilter(annotation));
        if (!InterfaceDao.class.equals(annotation)) {
            addIncludeFilter(new AnnotationTypeFilter(InterfaceDao.class));
        }
    }
	
	public InterfaceDaoClassPathMapperScanner(BeanDefinitionRegistry registry) {
		super(registry);
	}
	
	/**
     * 默认不允许接口的,这里重写,覆盖下,另外默认会扫描 @Component 这样所以的被@Component 注解的都会扫描
     */
    @Override
    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }


}
