package com.biz.eisp.base.interfacedao.interceptor;

import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.rpc.ResourceRpcService;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 添加默认字段拦截器
 * @author Sean
 *
 */
public class InterfaceDaoInterceptor implements EmptyInterceptor {

	/**
	 * 追加新增字段
	 */
	@Override
	public boolean onInsert(Field[] fields, Object obj) {
		Map<Object, Object> map = new HashMap<Object, Object>();
		for(int i=0;i<fields.length;i++){
			fields[i].setAccessible(true);
			String fieldName=fields[i].getName();
			if ("createName".equals(fieldName)) {
				ResourceRpcService resourceRpcService = ApplicationContextUtils.getContext().getBean(ResourceRpcService.class);
				map.put("createName", resourceRpcService.getSessionUserName().getUserName());
			}
			if ("createDate".equals(fieldName)) {
				map.put("createDate", new Date());
			}
		}
		return false;
	}

	/**
	 * 追加修改字段
	 */
	@Override
	public boolean onUpdate(Field[] fields, Object obj) {
		Map<Object, Object> map = new HashMap<Object, Object>();
		for(int i=0;i<fields.length;i++){
			fields[i].setAccessible(true);
			String fieldName=fields[i].getName();
			if ("updateName".equals(fieldName)) {
				ResourceRpcService resourceRpcService = ApplicationContextUtils.getContext().getBean(ResourceRpcService.class);
				map.put("updateName", resourceRpcService.getSessionUserName().getUserName());
			}
			if ("updateDate".equals(fieldName)) {
				map.put("updateDate", new Date());
			}
		}
		return false;
	}

	

}
