package com.biz.eisp.base.progress.listener;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import com.biz.eisp.base.progress.vo.ProgressInfo;

/**
 * 进度条接口实现
 * @author liukai
 *
 */
public class EispProgressListener implements ProgressListener{

	//Session对象
	private HttpSession session;
	//功能Key，例如价格申请提交功能functionKey=applyPriceSubmit
	private String functionKey = "default";
	
	/**
	 * 构造函数
	 * @param request 
	 * @param progressInfo 进度条信息对象
	 */
	public EispProgressListener(HttpServletRequest request, ProgressInfo progressInfo) {
		this.session = request.getSession();
		this.session.setAttribute(functionKey + "_progressStatus", progressInfo);
	}
	
	/**
	 * 构造函数
	 * @param request
	 * @param functionKey 功能key
	 * @param progressInfo 进度条信息对象
	 */
	public EispProgressListener(HttpServletRequest request, String functionKey, ProgressInfo progressInfo) {
		this.functionKey = functionKey;
		this.session = request.getSession();
		this.session.setAttribute(functionKey + "_progressStatus", progressInfo);
	}

	@Override
	public void next() {
		Object obj = session.getAttribute(functionKey + "_progressStatus");
		if(obj != null) {
			ProgressInfo progressInfo = (ProgressInfo) obj;
			progressInfo.next();
		}
	}
}
