package com.biz.eisp.base.progress.vo;

import java.io.Serializable;

/**
 * 进度条信息对象
 * @author liukai
 *
 */
public class ProgressInfo implements Serializable{

	private static final long serialVersionUID = 1L;
	
	private int total = Integer.MAX_VALUE; // 总条数
	private int current = 0; // 当前处理行
	private boolean isFinish = false; //是否完成 默认未完成

	public ProgressInfo() {
		
	}
	
	public ProgressInfo(int total) {
		this.total = total;
	}
	
	public int getTotal() {
		return total;
	}

	public void setTotal(int total) {
		this.total = total;
	}

	public int getCurrent() {
		return current;
	}

	public synchronized void next() {
		this.current++;
		if(this.current == total) {
			isFinish = true;
		}
	}
	
	public boolean isFinish() {
		return isFinish;
	}
	
}
