/**
 * @Description: 
 * @ClassName: com.ali.openim.util.ModelMapperUtils
 * @author: Omar(OmarZhang)
 * @date: 2015年12月3日 上午1:39:01 
 */
package com.biz.eisp.base.utils;

import org.modelmapper.ModelMapper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @Description: 
 * @ClassName: cn.com.bizunited.cp.common.utils.ModelMapperUtils
 * @author: Omar(OmarZhang)
 * @date: 2015年12月3日 上午1:39:01 
 *
 */
public final class ModelMapperUtils {
	
	private static ModelMapper modelMapper = new ModelMapper();
	
	private ModelMapperUtils(){}
	
	/**
	 * 源对象转换为目标对象
	 * @Title: toParse 
	 * @param sourceObj
	 * @param descObject
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2015年12月3日 上午1:41:20
	 */
	public static <E>  E toParse (Object sourceObj,Class<E> descObject) {
        if(sourceObj==null){
            return null;
        }
		return modelMapper.map(sourceObj, descObject);
	}
	
	/**
	 * 源对象集合转换为目标对象集合
	 * @Title: toParseList 
	 * @param sourceObjList
	 * @param descObject
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2015年12月3日 上午1:55:33
	 */
	public static <E, H> List<E> toParseList (List<H> sourceObjList,Class<E> descObject){
		List<E> tempList = new ArrayList<E>(sourceObjList.size());
		for(Iterator<H> it = sourceObjList.iterator();it.hasNext();) {
			H h = it.next();
			tempList.add(toParse(h, descObject));
		}
		return tempList;
	}

}
