package com.biz.eisp.base.utils;

import com.biz.eisp.base.common.util.ContextHolderUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.ResourceBundle;

/**
 * 项目参数工具类
 * 
 */
public class ResourceUtil {
	
	/**
	 * @Description: TODO(获取请求方法)
	 * @param request
	 * @return
	 */
	public static String getRequestPath(HttpServletRequest request) {
		String requestPath = request.getRequestURI() + "?" + request.getQueryString();
		if (requestPath.indexOf("&") > -1) {// 去掉其他参数
			requestPath = requestPath.substring(0, requestPath.indexOf("&"));
		}
		requestPath = requestPath.substring(request.getContextPath().length() + 1);// 去掉项目路径
		return requestPath;
	}
	
	public static String getParameter(String field) {
		HttpServletRequest request = ContextHolderUtils.getRequest();
		return request.getParameter(field);
	}
    /**
     * 获取sysconfig资源.
     * @author grover
     * @param propertyName 资源属性
     * @return 资源配置值
     */
    public static final String getSysConfigProperty(String propertyName){
    	//返回值
    	String value = null;
    	//获取资源文件
    	ResourceBundle rb = ResourceBundle.getBundle("sysconfig");  
    	//读取值
    	if(rb.containsKey(propertyName)){
    		value = rb.getString(propertyName);
    	}
		return value;
    }
}
