package com.biz.eisp.es.esentity;

import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldIndex;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.Date;

/**
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/4/13
 */
public abstract class BaseLogable extends BaseESO {

    //数据库中的id
    @Field(type = FieldType.String, index = FieldIndex.not_analyzed, store = true)
    protected String dbId;

    //数据变更时间
    @Field(type = FieldType.Date, index = FieldIndex.not_analyzed, store = true)
    protected Date changeDate = new Date();

    public String getDbId() {
        return dbId;
    }

    public void setDbId(String dbId) {
        this.dbId = dbId;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
}
