package com.biz.eisp.es.service;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.es.esentity.BaseLogable;
import org.springframework.data.domain.Page;

import java.util.List;

/**
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/4/13
 */
public interface BaseLogableService<ESO extends BaseLogable,E extends IdEntity> extends BaseElasticSearchService<ESO,E> {

    /**
     * 根据数据库中的id查找所有变更记录
     * @param dbid 数据库中的id
     * @return
     */
    List<ESO> findByDBId(String dbid);

    /**
     * 根据数据库中的id分页查找变更记录
     * @param dbid 数据库中的id
     * @param curentPage 当前页码从0开始
     * @param pageSize 每页显示数量
     * @return
     */
    Page<ESO> findByDBId(String dbid, Integer curentPage, Integer pageSize);
}
