package com.biz.eisp.es.service.impl;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.es.esentity.BaseESO;
import com.biz.eisp.es.esrepository.BaseElasticsearchRepository;
import com.biz.eisp.es.service.BaseElasticSearchService;
import com.google.common.collect.Lists;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;

import java.util.List;

/**
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/4/13
 */
public abstract class BaseElasticSearchServiceImpl<ESO extends BaseESO,E extends IdEntity> implements BaseElasticSearchService<ESO,E> {

    protected BaseElasticsearchRepository<ESO> elasticsearchRepository;

    protected ElasticsearchTemplate elasticsearchTemplate;

    public <T extends BaseElasticsearchRepository<ESO>> BaseElasticSearchServiceImpl(T elasticsearchRepository, ElasticsearchTemplate elasticsearchTemplate) {
        this.elasticsearchRepository = elasticsearchRepository;
        this.elasticsearchTemplate = elasticsearchTemplate;
    }

    @Override
    public void save(E e){
        ESO eso = apply(e);
        elasticsearchRepository.save(eso);
    }

    @Override
    public void save(List<E> es) {
        List<ESO> esos = Lists.transform(es, this);
        elasticsearchRepository.save(esos);
    }

    @Override
    public void delete(String esId) {
        elasticsearchRepository.delete(esId);
    }

    @Override
    public ESO apply(E e) {
        Class<ESO> esoClass = elasticsearchRepository.getEntityClass();
        ESO eso = null;
        try {
            eso = esoClass.newInstance();
            MyBeanUtils.copyBean2Bean(eso,e);
        } catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
        return eso;
    }
}
