package com.biz.eisp.es.service.impl;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.base.utils.UUIDGenerator;
import com.biz.eisp.es.esentity.BaseLogable;
import com.biz.eisp.es.esrepository.BaseElasticsearchRepository;
import com.biz.eisp.es.service.BaseLogableService;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;

import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/4/13
 */
public abstract class BaseLogableServiceImpl<ESO extends BaseLogable,E extends IdEntity>  extends BaseElasticSearchServiceImpl<ESO,E> implements BaseLogableService<ESO,E> {

    public <T extends BaseElasticsearchRepository<ESO>> BaseLogableServiceImpl(T elasticsearchRepository, ElasticsearchTemplate elasticsearchTemplate) {
        super(elasticsearchRepository,elasticsearchTemplate);
    }

    @Override
    public List<ESO> findByDBId(String dbid) {
        if (StringUtils.isEmpty(dbid))
            return Collections.emptyList();
        List<ESO> esos = elasticsearchTemplate.queryForList(buildDBIdQuery(dbid, null, null), elasticsearchRepository.getEntityClass());
        return esos;
    }

    @Override
    public Page<ESO> findByDBId(String dbid, Integer currentPage, Integer pageSize) {
        if (StringUtils.isEmpty(dbid))
            return null;
        Page<ESO> search = super.elasticsearchRepository.search(buildDBIdQuery(dbid, currentPage, pageSize));
        return search;
    }

    protected SearchQuery buildDBIdQuery(String dbid, Integer currentPage, Integer pageSize){
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        TermQueryBuilder dbidQuery = QueryBuilders.termQuery("dbId", dbid);
        boolQueryBuilder.must(dbidQuery);
        Pageable pageable = currentPage!=null&&pageSize!=null?new PageRequest(currentPage, pageSize, new Sort(Sort.Direction.DESC, "changeDate")):null;
        FieldSortBuilder sortBuilder = SortBuilders.fieldSort("changeDate").order(SortOrder.DESC);
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder().withQuery(boolQueryBuilder).withSort(sortBuilder);
        if (pageable !=null ){
            nativeSearchQueryBuilder.withPageable(pageable);
        }
        return nativeSearchQueryBuilder.build();
    }

    @Override
    public ESO apply(E e) {
        ESO eso = super.apply(e);
        if (eso != null){
            eso.setDbId(e.getId());
            eso.setId(UUIDGenerator.generate());
            eso.setChangeDate(new Date());
        }
        return eso;
    }
}
