/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.tag.tags;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.tag.bean.ColumnValue;
import com.biz.eisp.base.common.tag.bean.DataGridUrl;
import com.biz.eisp.base.common.tag.bean.Expression;
import com.biz.eisp.base.common.tag.params.DataGridParams;
import com.biz.eisp.base.common.tag.tags.DataGridColumnTag;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TagUtil;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.base.utils.FreemarkerParseUtils;
import com.biz.eisp.base.utils.ModelMapperUtils;
import com.biz.eisp.rpc.DynamicConfigRpcService;
import com.biz.eisp.vo.DataGridColumn;
import com.biz.eisp.vo.DictDataVo;
import com.biz.eisp.vo.TmOperationVo;
import com.biz.eisp.vo.TmTableConfigVo;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DataGridTag
extends TagSupport {
    protected String fields = "";
    protected String searchFields = "";
    protected String name;
    protected String title;
    protected String idField = "id";
    protected boolean treegrid = false;
    public Map<String, Object> map;
    private String actionUrl;
    public int allCount;
    public int curPageNo;
    public int pageSize = 10;
    public boolean pagination = true;
    private String width;
    private String height;
    private boolean checkbox = false;
    private boolean showPageList = true;
    private boolean openFirstNode = false;
    private boolean fit = true;
    private boolean fitColumns = true;
    private boolean singleSelect = true;
    private String sortName;
    private String sortOrder = "asc";
    private boolean showRefresh = true;
    private boolean showText = true;
    private String style = "easyui";
    private String onLoadSuccess;
    private String onClick;
    private String onDblClick;
    private String queryMode = "single";
    private String entityName;
    private String rowStyler;
    private String extendParams;
    private String extendTableName;
    private boolean autoLoadData = true;
    private boolean queryBuilder = false;
    protected List<DataGridUrl> urlList = new ArrayList<DataGridUrl>();
    protected List<DataGridUrl> toolBarList = new ArrayList<DataGridUrl>();
    protected List<DataGridColumn> columnList = new ArrayList<DataGridColumn>();
    protected List<DataGridColumn> multiMeterColumnList = new ArrayList<DataGridColumn>();
    protected List<ColumnValue> columnValueList = new ArrayList<ColumnValue>();
    protected List<ColumnValue> columnStyleList = new ArrayList<ColumnValue>();
    protected List<TmTableConfigVo> tableConfigList = new ArrayList<TmTableConfigVo>();
    protected static Map<String, String> syscode = new HashMap<String, String>();
    @Autowired
    private static BaseService baseService;

    public void setConfUrl(String url, String title, String message, String exp, String operationCode) {
        DataGridUrl dataGridUrl = new DataGridUrl();
        dataGridUrl.setTitle(title);
        dataGridUrl.setUrl(url);
        dataGridUrl.setType("Confirm");
        dataGridUrl.setMessage(message);
        dataGridUrl.setExps(this.getExp(exp));
        this.installOperationCode(dataGridUrl, operationCode, this.urlList);
    }

    public void setDelUrl(String url, String title, String message, String exp, String funname, String operationCode) {
        DataGridUrl dataGridUrl = new DataGridUrl();
        dataGridUrl.setTitle(title);
        dataGridUrl.setUrl(url);
        dataGridUrl.setType("Del");
        dataGridUrl.setMessage(message);
        dataGridUrl.setExps(this.getExp(exp));
        dataGridUrl.setFunname(funname);
        this.installOperationCode(dataGridUrl, operationCode, this.urlList);
    }

    public void setDefUrl(String url, String title, String exp, String operationCode) {
        DataGridUrl dataGridUrl = new DataGridUrl();
        dataGridUrl.setTitle(title);
        dataGridUrl.setUrl(url);
        dataGridUrl.setType("Deff");
        dataGridUrl.setExps(this.getExp(exp));
        this.installOperationCode(dataGridUrl, operationCode, this.urlList);
    }

    public void setToolbar(String url, String title, String icon, String exp, String onclick, String funname, String operationCode, String width, String height, String id, String params) {
        DataGridUrl dataGridUrl = new DataGridUrl();
        if (StringUtils.isBlank((String)id)) {
            dataGridUrl.setId(UUID.randomUUID().toString());
        } else {
            dataGridUrl.setId(id);
        }
        dataGridUrl.setTitle(title);
        dataGridUrl.setUrl(url);
        dataGridUrl.setType("ToolBar");
        dataGridUrl.setIcon(icon);
        dataGridUrl.setExps(this.getExp(exp));
        dataGridUrl.setOnclick(onclick);
        dataGridUrl.setFunname(funname);
        dataGridUrl.setParams(params == null ? "" : params);
        dataGridUrl.setWidth(width == null ? "" : width);
        dataGridUrl.setHeight(height == null ? "" : height);
        this.installOperationCode(dataGridUrl, operationCode, this.toolBarList);
    }

    public void setFunUrl(String title, String exp, String funname, String operationCode) {
        DataGridUrl dataGridUrl = new DataGridUrl();
        dataGridUrl.setTitle(title);
        dataGridUrl.setType("Fun");
        dataGridUrl.setExps(this.getExp(exp));
        dataGridUrl.setFunname(funname);
        String parmars = TagUtil.getFunParams(dataGridUrl.getFunname());
        dataGridUrl.setParam(parmars);
        this.installOperationCode(dataGridUrl, operationCode, this.urlList);
    }

    public void setOpenUrl(String url, String title, String width, String height, String exp, String operationCode, String openModel) {
        DataGridUrl dataGridUrl = new DataGridUrl();
        dataGridUrl.setTitle(title);
        dataGridUrl.setUrl(url);
        dataGridUrl.setWidth(width);
        dataGridUrl.setHeight(height);
        dataGridUrl.setType(openModel);
        dataGridUrl.setExps(this.getExp(exp));
        this.installOperationCode(dataGridUrl, operationCode, this.urlList);
    }

    private List<Expression> getExp(String exp) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        if (StringUtils.isNotBlank((String)exp)) {
            String[] showbyFields = exp.split("&&").length == 0 ? exp.split("||") : exp.split("&&");
            for (int i = 0; i < showbyFields.length; ++i) {
                String showbyField = showbyFields[i];
                Expression e = new Expression();
                int beginIndex = showbyField.indexOf("#");
                int endIndex = showbyField.lastIndexOf("#");
                String exptype = showbyField.substring(beginIndex + 1, endIndex);
                String field = showbyField.substring(0, beginIndex);
                String[] values = showbyField.substring(endIndex + 1, showbyField.length()).split(",");
                String value = "";
                for (int j = 0; j < values.length; ++j) {
                    value = value + "" + values[j] + "";
                    if (j >= values.length - 1) continue;
                    value = value + ",";
                }
                e.setValue(value);
                e.setCondition(exptype);
                e.setParam(field);
                list.add(e);
            }
        }
        return list;
    }

    public void setColumn(DataGridColumn dataGridColumn) {
        String value;
        String text;
        if (StringUtil.isNotEmpty((String)dataGridColumn.getColspan()) || StringUtil.isNotEmpty((String)dataGridColumn.getRowspan())) {
            this.multiMeterColumnList.add(dataGridColumn);
        } else {
            this.columnList.add(dataGridColumn);
        }
        String field = dataGridColumn.getField();
        String replace = dataGridColumn.getReplace();
        String dictionary = dataGridColumn.getDictionary();
        Object popup = null;
        List operationCodes = (List)this.pageContext.getRequest().getAttribute(Globals.No_Operation_Codes);
        if (null != operationCodes) {
            List<TmOperationVo> tmOperationVos = ModelMapperUtils.toParseList(operationCodes, TmOperationVo.class);
            for (TmOperationVo operationEntity : tmOperationVos) {
                if (StringUtil.isEmpty(operationEntity.getOperationCode())) break;
                baseService = (BaseService)ApplicationContextUtils.getContext().getBean("baseService");
                if (!operationEntity.getOperationCode().equals(dataGridColumn.getField())) continue;
                this.columnList.remove(dataGridColumn);
            }
        }
        if (field != "opt") {
            this.fields = this.fields + field + ",";
            this.searchFields = "group".equals(this.queryMode) ? this.searchFields + field + "," + field + "_begin," + field + "_end," : this.searchFields + field + ",";
        }
        if (StringUtils.isNotEmpty((String)replace)) {
            String[] test = replace.split(",");
            String lang_key = "";
            text = "";
            value = "";
            String[] stringArray = test;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                lang_key = string.substring(0, string.indexOf("_"));
                text = text + lang_key + ",";
                value = value + string.substring(string.indexOf("_") + 1) + ",";
            }
            this.setColumn(field, text, value);
        }
        if (!StringUtils.isBlank((String)dictionary)) {
            String[] enumInfo = null;
            boolean enumSuccess = false;
            if (dictionary.startsWith("enum")) {
                String enumClzName;
                enumInfo = dictionary.split(",");
                if (enumInfo.length == 4) {
                    enumClzName = enumInfo[1];
                    String enumValueFiled = enumInfo[2];
                    String enumDescFiled = enumInfo[3];
                    try {
                        char[] enumDescChars;
                        Class<?> enumClazz = Class.forName(enumClzName);
                        Method method = enumClazz.getMethod("values", new Class[0]);
                        char[] enumValueChars = enumValueFiled.toCharArray();
                        if ('a' <= enumValueChars[0] && enumValueChars[0] <= 'z') {
                            enumValueChars[0] = (char)(enumValueChars[0] + -32);
                        }
                        if ('a' <= (enumDescChars = enumDescFiled.toCharArray())[0] && enumDescChars[0] <= 'z') {
                            enumDescChars[0] = (char)(enumDescChars[0] + -32);
                        }
                        Method getValueMethod = enumClazz.getMethod("get" + String.valueOf(enumValueChars), new Class[0]);
                        Method getDescMethod = enumClazz.getMethod("get" + String.valueOf(enumDescChars), new Class[0]);
                        Object[] enums = (Object[])method.invoke(null, new Object[0]);
                        String text1 = "";
                        String value1 = "";
                        for (Object e : enums) {
                            Object value2 = getValueMethod.invoke(e, new Object[0]);
                            Object desc = getDescMethod.invoke(e, new Object[0]);
                            text1 = text1 + desc + ",";
                            value1 = value1 + value2 + ",";
                        }
                        this.setColumn(field, text1, value1);
                        enumSuccess = true;
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                } else if (enumInfo.length == 3) {
                    enumClzName = enumInfo[1];
                    String enumDescFiled = enumInfo[2];
                    Class<?> enumClazz = null;
                    try {
                        enumClazz = Class.forName(enumClzName);
                        Method method = enumClazz.getMethod("values", new Class[0]);
                        char[] enumDescChars = enumDescFiled.toCharArray();
                        if ('a' <= enumDescChars[0] && enumDescChars[0] <= 'z') {
                            enumDescChars[0] = (char)(enumDescChars[0] + -32);
                        }
                        Method getDescMethod = enumClazz.getMethod("get" + String.valueOf(enumDescChars), new Class[0]);
                        Object[] enums = (Object[])method.invoke(null, new Object[0]);
                        String text1 = "";
                        String value1 = "";
                        for (Object e : enums) {
                            Object desc = getDescMethod.invoke(e, new Object[0]);
                            text1 = text1 + desc + ",";
                            value1 = value1 + e + ",";
                        }
                        this.setColumn(field, text1, value1);
                        enumSuccess = true;
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!enumSuccess) {
                if (dictionary.contains(",")) {
                    String[] dic = dictionary.split(",");
                    String text2 = "";
                    String value3 = "";
                    String sql = "select " + dic[1] + " as field," + dic[2] + " as text from " + dic[0];
                    List<Map<String, Object>> list = baseService.findForMapList(sql, new Object[0]);
                    for (Map<String, Object> map : list) {
                        text2 = text2 + map.get("text") + ",";
                        value3 = value3 + map.get("field") + ",";
                    }
                    if (list.size() > 0) {
                        this.setColumn(field, text2, value3);
                    }
                } else {
                    text = "";
                    value = "";
                    baseService = (BaseService)ApplicationContextUtils.getContext().getBean("baseService");
                    List<DictDataVo> dictDataList = baseService.findBySql(DictDataVo.class, "select dict_code dictCode,dict_value dictValue  from tm_dict_data where dict_type_code=?", dictionary);
                    for (DictDataVo data : dictDataList) {
                        text = text + data.getDictValue() + ",";
                        value = value + data.getDictCode() + ",";
                    }
                    this.setColumn(field, text, value);
                }
            }
        }
        if (StringUtils.isNotEmpty((String)this.style)) {
            String[] temp = this.style.split(",");
            String text3 = "";
            String value4 = "";
            if (temp.length == 1 && temp[0].indexOf("_") == -1) {
                text3 = temp[0];
            } else {
                for (String string : temp) {
                    text3 = text3 + string.substring(0, string.indexOf("_")) + ",";
                    value4 = value4 + string.substring(string.indexOf("_") + 1) + ",";
                }
            }
            this.setStyleColumn(field, text3, value4);
        }
    }

    private void installOperationCode(DataGridUrl dataGridUrl, String operationCode, List optList) {
        if (!StringUtil.isEmpty(operationCode)) {
            List operationCodes = (List)this.pageContext.getRequest().getAttribute(Globals.No_Operation_Codes);
            if (null != operationCodes) {
                List<TmOperationVo> tmOperationVos = ModelMapperUtils.toParseList(operationCodes, TmOperationVo.class);
                ArrayList<String> operationCodesStr = new ArrayList<String>();
                for (TmOperationVo operationEntity : tmOperationVos) {
                    if (StringUtil.isEmpty(operationEntity.getOperationCode())) break;
                    operationCodesStr.add(operationEntity.getOperationCode());
                }
                if (!operationCodesStr.contains(operationCode)) {
                    optList.add(dataGridUrl);
                }
            }
        } else {
            optList.add(dataGridUrl);
        }
    }

    private void setStyleColumn(String field, String text, String value) {
        ColumnValue columnValue = new ColumnValue();
        columnValue.setName(field);
        columnValue.setText(text);
        columnValue.setValue(value);
        this.columnStyleList.add(columnValue);
    }

    public void setColumn(String name, String text, String value) {
        ColumnValue columnValue = new ColumnValue();
        columnValue.setName(name);
        columnValue.setText(text);
        columnValue.setValue(value);
        this.columnValueList.add(columnValue);
    }

    public int doStartTag() throws JspTagException {
        this.urlList.clear();
        this.toolBarList.clear();
        this.columnValueList.clear();
        this.columnStyleList.clear();
        this.columnList.clear();
        this.multiMeterColumnList.clear();
        this.fields = "";
        this.searchFields = "";
        return 6;
    }

    public int doEndTag() throws JspException {
        try {
            JspWriter out = this.pageContext.getOut();
            out.print(this.end());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 6;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    private void setExtendColumn() {
        DynamicConfigRpcService dynamicConfigRpcService = (DynamicConfigRpcService)ApplicationContextUtils.getContext().getBean("dynamicConfigRpcServiceImpl");
        List dataGridColumnList = dynamicConfigRpcService.buildDataGridColumn(this.extendTableName, this.treegrid);
        if (CollectionUtil.listNotEmptyNotSizeZero(dataGridColumnList)) {
            for (int i = 0; i < dataGridColumnList.size(); ++i) {
                DataGridColumn dataGridColumn = (DataGridColumn)dataGridColumnList.get(i);
                dataGridColumn.setCheckbox(this.checkbox);
                this.setColumn(dataGridColumn);
            }
        }
    }

    public String end() {
        if (StringUtils.isNotBlank((String)this.extendTableName)) {
            this.setExtendColumn();
        }
        DataGridParams dataGridParams = new DataGridParams();
        dataGridParams.setCheckbox(String.valueOf(this.checkbox));
        dataGridParams.setSingleSelect(String.valueOf(this.singleSelect));
        dataGridParams.setQueryMode(this.queryMode);
        dataGridParams.setWidth(this.width == null ? "auto" : this.width);
        dataGridParams.setHeight(this.height == null ? "auto" : this.height);
        dataGridParams.setTreegrid(String.valueOf(this.treegrid));
        dataGridParams.setName(this.name);
        dataGridParams.setActionUrl(this.actionUrl);
        dataGridParams.setTitle(this.title);
        dataGridParams.setRowStyler(this.rowStyler);
        dataGridParams.setFit(String.valueOf(this.fit));
        dataGridParams.setFitColumns(String.valueOf(this.fitColumns));
        dataGridParams.setToolBarList(this.toolBarList);
        dataGridParams.setColumnStyleList(this.columnStyleList);
        dataGridParams.setColumnValueList(this.columnValueList);
        dataGridParams.setMultiMeterColumnList(this.multiMeterColumnList);
        Collections.sort(this.columnList);
        dataGridParams.setColumnList(this.columnList);
        dataGridParams.setFields(this.fields);
        dataGridParams.setSearchFields(this.searchFields);
        dataGridParams.setIdField(this.idField);
        dataGridParams.setMap(this.map);
        dataGridParams.setAllCount(this.allCount);
        dataGridParams.setCurPageNo(this.curPageNo);
        dataGridParams.setPageSize(this.pageSize);
        dataGridParams.setPagination(String.valueOf(this.pagination));
        dataGridParams.setShowPageList(String.valueOf(this.showPageList));
        dataGridParams.setOpenFirstNode(String.valueOf(this.openFirstNode));
        dataGridParams.setSortName(this.sortName);
        dataGridParams.setSortOrder(this.sortOrder);
        dataGridParams.setShowRefresh(String.valueOf(this.showRefresh));
        dataGridParams.setShowText(String.valueOf(this.showText));
        dataGridParams.setStyle(this.style);
        dataGridParams.setOnLoadSuccess(this.onLoadSuccess);
        dataGridParams.setOnClick(this.onClick);
        dataGridParams.setOnDblClick(this.onDblClick);
        dataGridParams.setEntityName(this.entityName);
        dataGridParams.setExtendParams(this.extendParams);
        dataGridParams.setAutoLoadData(String.valueOf(this.autoLoadData));
        dataGridParams.setUrlList(this.urlList);
        FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("param", dataGridParams);
        String content = freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/datagrid.ftl", param);
        return content;
    }

    public DataGridColumnTag getDataGridColumnTag() {
        DataGridColumnTag dataGridColumnTag = new DataGridColumnTag();
        return dataGridColumnTag;
    }

    public boolean isFitColumns() {
        return this.fitColumns;
    }

    public void setFitColumns(boolean fitColumns) {
        this.fitColumns = fitColumns;
    }

    public String getSortName() {
        return this.sortName;
    }

    public void setSortName(String sortName) {
        this.sortName = sortName;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getQueryMode() {
        return this.queryMode;
    }

    public void setQueryMode(String queryMode) {
        this.queryMode = queryMode;
    }

    public boolean isAutoLoadData() {
        return this.autoLoadData;
    }

    public void setAutoLoadData(boolean autoLoadData) {
        this.autoLoadData = autoLoadData;
    }

    public void setOpenFirstNode(boolean openFirstNode) {
        this.openFirstNode = openFirstNode;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setRowStyler(String rowStyler) {
        this.rowStyler = rowStyler;
    }

    public void setExtendParams(String extendParams) {
        this.extendParams = extendParams;
    }

    public boolean isQueryBuilder() {
        return this.queryBuilder;
    }

    public void setQueryBuilder(boolean queryBulder) {
        this.queryBuilder = queryBulder;
    }

    public void setOnLoadSuccess(String onLoadSuccess) {
        this.onLoadSuccess = onLoadSuccess;
    }

    public void setOnClick(String onClick) {
        this.onClick = onClick;
    }

    public void setOnDblClick(String onDblClick) {
        this.onDblClick = onDblClick;
    }

    public void setShowText(boolean showText) {
        this.showText = showText;
    }

    public void setPagination(boolean pagination) {
        this.pagination = pagination;
    }

    public void setCheckbox(boolean checkbox) {
        this.checkbox = checkbox;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTreegrid(boolean treegrid) {
        this.treegrid = treegrid;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setIdField(String idField) {
        this.idField = idField;
    }

    public void setActionUrl(String actionUrl) {
        this.actionUrl = actionUrl;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFit(boolean fit) {
        this.fit = fit;
    }

    public void setShowPageList(boolean showPageList) {
        this.showPageList = showPageList;
    }

    public void setShowRefresh(boolean showRefresh) {
        this.showRefresh = showRefresh;
    }

    public String getExtendTableName() {
        return this.extendTableName;
    }

    public void setExtendTableName(String extendTableName) {
        this.extendTableName = extendTableName;
    }

    public boolean isSingleSelect() {
        return this.singleSelect;
    }

    public void setSingleSelect(boolean singleSelect) {
        this.singleSelect = singleSelect;
    }

    static {
        syscode.put("class", "clazz");
    }
}

