/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.converter;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.AttributeConverter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractListBaseTypeConverter<E extends Serializable>
implements AttributeConverter<List<? extends E>, String> {
    private static final String separator = ",";
    private ToDBStringFunction toDBStringFunction = new ToDBStringFunction();
    private ToSystemObjectFunction toSystemObjectFunction = new ToSystemObjectFunction();

    public String convertToDatabaseColumn(List<? extends E> attribute) {
        if (this.toDBStringFunction == null) {
            this.toDBStringFunction = new ToDBStringFunction();
        }
        if (CollectionUtils.isNotEmpty(attribute)) {
            String dbString = StringUtils.join((Collection)Lists.transform(attribute, (Function)this.toDBStringFunction), (String)separator);
            return dbString;
        }
        return null;
    }

    public List<? extends E> convertToEntityAttribute(String dbData) {
        if (this.toSystemObjectFunction == null) {
            this.toSystemObjectFunction = new ToSystemObjectFunction();
        }
        if (StringUtils.isNotEmpty((String)dbData)) {
            String[] strs = dbData.split(separator);
            List<String> strings = Arrays.asList(strs);
            ArrayList result = Lists.newArrayList((Iterable)Lists.transform(strings, (Function)this.toSystemObjectFunction));
            return result;
        }
        return Lists.newArrayList();
    }

    protected abstract E toSystemObject(String var1);

    protected abstract String toDBAttributeString(E var1);

    private class ToSystemObjectFunction
    implements Function<String, E> {
        private ToSystemObjectFunction() {
        }

        public E apply(String s) {
            return AbstractListBaseTypeConverter.this.toSystemObject(s);
        }
    }

    private class ToDBStringFunction
    implements Function<E, String> {
        private ToDBStringFunction() {
        }

        public String apply(E e) {
            return AbstractListBaseTypeConverter.this.toDBAttributeString(e);
        }
    }
}

