/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.converter;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.enums.EnumerableValue;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeConverter;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseListEnumConverter<E extends EnumerableValue>
implements AttributeConverter<List<? extends EnumerableValue>, String> {
    private static final String separator = ",";
    private Class<E> clz;
    private Map<Integer, E> enumMap = new HashMap<Integer, E>();

    public BaseListEnumConverter() {
        try {
            this.clz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            Method method = this.clz.getMethod("values", new Class[0]);
            for (EnumerableValue e : (EnumerableValue[])method.invoke(null, new Object[0])) {
                this.enumMap.put(e.getValue(), e);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u53cd\u5c04\u5931\u8d25", e);
        }
    }

    public String convertToDatabaseColumn(List<? extends EnumerableValue> list) {
        return this.toString(list);
    }

    public List<E> convertToEntityAttribute(String dbData) {
        return this.toList(dbData);
    }

    public String toString(List<? extends EnumerableValue> list) {
        if (list == null) {
            return "";
        }
        List strList = Lists.transform(list, (Function)new Function<EnumerableValue, String>(){

            public String apply(EnumerableValue input) {
                return String.valueOf(input.getValue());
            }
        });
        return Joiner.on((String)separator).join((Iterable)strList);
    }

    public List<E> toList(String dbString) {
        if (StringUtils.isEmpty((CharSequence)dbString) || this.enumMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        List valueList = Splitter.on((String)separator).splitToList((CharSequence)dbString);
        for (String value : valueList) {
            EnumerableValue e = (EnumerableValue)this.enumMap.get(Integer.valueOf(value));
            if (e == null) continue;
            result.add(e);
        }
        return result;
    }
}

