/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.converter;

import com.biz.eisp.base.converter.AbstractListBaseTypeConverter;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public interface ListBaseTypeConverter {

    public static class ListBigDecimalConverter
    extends AbstractListBaseTypeConverter<BigDecimal> {
        @Override
        protected BigDecimal toSystemObject(String attributeString) {
            return new BigDecimal(attributeString);
        }

        @Override
        protected String toDBAttributeString(BigDecimal attribute) {
            return attribute.toString();
        }
    }

    public static class ListTimeConverter
    extends AbstractListBaseTypeConverter<Time> {
        @Override
        protected Time toSystemObject(String attributeString) {
            return StringUtils.isNotEmpty((String)attributeString) ? new Time(Long.parseLong(attributeString)) : null;
        }

        @Override
        protected String toDBAttributeString(Time attribute) {
            return attribute == null ? null : String.valueOf(attribute.getTime());
        }
    }

    public static class ListDateConverter
    extends AbstractListBaseTypeConverter<Date> {
        @Override
        protected Date toSystemObject(String attributeString) {
            return StringUtils.isNotEmpty((String)attributeString) ? new Date(Long.parseLong(attributeString)) : null;
        }

        @Override
        protected String toDBAttributeString(Date attribute) {
            return attribute == null ? null : String.valueOf(attribute.getTime());
        }
    }

    public static class ListDoubleConverter
    extends AbstractListBaseTypeConverter<Double> {
        @Override
        protected Double toSystemObject(String attributeString) {
            return StringUtils.isNotEmpty((String)attributeString) ? Double.valueOf(Double.parseDouble(attributeString)) : null;
        }

        @Override
        protected String toDBAttributeString(Double attribute) {
            return attribute == null ? null : attribute.toString();
        }
    }

    public static class ListLongConverter
    extends AbstractListBaseTypeConverter<Long> {
        @Override
        protected Long toSystemObject(String attributeString) {
            return StringUtils.isNotEmpty((String)attributeString) ? Long.valueOf(Long.parseLong(attributeString)) : null;
        }

        @Override
        protected String toDBAttributeString(Long attribute) {
            return attribute == null ? null : attribute.toString();
        }
    }

    public static class ListIntegerConverter
    extends AbstractListBaseTypeConverter<Integer> {
        @Override
        protected Integer toSystemObject(String attributeString) {
            return StringUtils.isNotEmpty((String)attributeString) ? Integer.valueOf(Integer.parseInt(attributeString)) : null;
        }

        @Override
        protected String toDBAttributeString(Integer attribute) {
            return attribute == null ? null : attribute.toString();
        }
    }

    public static class ListStringConverter
    extends AbstractListBaseTypeConverter<String> {
        @Override
        protected String toSystemObject(String attributeString) {
            return attributeString;
        }

        @Override
        protected String toDBAttributeString(String attribute) {
            return attribute;
        }
    }
}

