/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.core.interceptors;

import com.biz.eisp.rpc.AuthObjectRpcService;
import com.biz.eisp.rpc.ResourceRpcService;
import java.io.Serializable;
import java.util.Date;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="hibernateEntityInterceptor")
public class HibernateEntityInterceptor
extends EmptyInterceptor {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ResourceRpcService resourceRpcService;
    @Autowired
    private AuthObjectRpcService authObjectRpcService;

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        String currentName = null;
        Subject subject = SecurityUtils.getSubject();
        if (subject != null) {
            Object principal = subject.getPrincipal();
            currentName = (String)principal;
        }
        for (int i = 0; i < propertyNames.length; ++i) {
            if ("createDate".equals(propertyNames[i])) {
                if (!this.isEmpty(state[i])) continue;
                state[i] = new Date();
                continue;
            }
            if ("createName".equals(propertyNames[i])) {
                if (!this.isEmpty(state[i])) continue;
                state[i] = currentName;
                continue;
            }
            if ("updateDate".equals(propertyNames[i])) {
                if (!this.isEmpty(state[i])) continue;
                state[i] = new Date();
                continue;
            }
            if ("updateName".equals(propertyNames[i])) {
                if (!this.isEmpty(state[i])) continue;
                state[i] = currentName;
                continue;
            }
            if (!"createPosId".equals(propertyNames[i]) || !this.isEmpty(state[i]) || currentName == null) continue;
            state[i] = this.resourceRpcService.getCurrPosition(currentName).getId();
        }
        return true;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        String currentName = null;
        Subject subject = SecurityUtils.getSubject();
        if (subject != null) {
            Object principal = subject.getPrincipal();
            currentName = (String)principal;
        }
        for (int i = 0; i < propertyNames.length; ++i) {
            if ("updateDate".equals(propertyNames[i])) {
                currentState[i] = new Date();
                continue;
            }
            if ("updateName".equals(propertyNames[i])) {
                currentState[i] = currentName;
                continue;
            }
            if (!"updatePosId".equals(propertyNames[i]) || currentName == null) continue;
            currentState[i] = this.resourceRpcService.getCurrPosition(currentName).getId();
        }
        return true;
    }

    public boolean isEmpty(Object object) {
        return object == null || object.equals("") || object.equals("null");
    }

    public String onPrepareStatement(String sql) {
        return this.authObjectRpcService.executeAuthHandle(sql);
    }
}

