/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.core.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.BrowserUtils;
import com.biz.eisp.base.core.interceptors.PageInterceptor;
import com.biz.eisp.base.core.web.converter.DateEditor;
import com.biz.eisp.base.exporter.ExcelExportUtil;
import com.biz.eisp.base.exporter.entity.ExcelTitle;
import com.biz.eisp.page.Page;
import com.biz.eisp.rpc.ResourceRpcService;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/baseController"})
public class BaseController {
    protected String message = "\u64cd\u4f5c\u6210\u529f";
    protected boolean success = true;
    @Autowired
    private ResourceRpcService resourceRpcService;
    protected Page page = PageInterceptor.getPage();

    @InitBinder
    public void initBinder(ServletRequestDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new DateEditor());
    }

    public String getCurrentName() {
        Subject subject = SecurityUtils.getSubject();
        String name = null;
        if (subject != null) {
            Object principal = subject.getPrincipal();
            name = (String)principal;
        }
        return name;
    }

    public void datagridReturn(HttpServletResponse response, List list, Page pg) {
        JSONObject json = new JSONObject();
        json.put("success", (Object)this.success);
        json.put("pages", pg.get((Object)Page.PAGE));
        json.put("total", pg.get((Object)Page.TOTAL));
        json.put("rows", (Object)list);
        this.doSend(response, json.toJSONString());
    }

    public void datagridReturn(HttpServletResponse response, List list) {
        JSONObject json = new JSONObject();
        json.put("success", (Object)this.success);
        json.put("total", (Object)0);
        json.put("rows", (Object)list);
        this.doSend(response, json.toJSONString());
    }

    public void sendResponseJson(HttpServletResponse response, JSONObject json) {
        this.doSend(response, json.toJSONString());
    }

    public void sendResponse(HttpServletResponse response) {
        JSONObject json = new JSONObject();
        json.put("success", (Object)this.success);
        json.put("msg", (Object)this.message);
        this.doSend(response, json.toJSONString());
    }

    public void sendResponseObj(HttpServletResponse response, Object obj) {
        this.doSend(response, JSON.toJSONString((Object)obj, (boolean)true));
    }

    public void sendObjToJSON(HttpServletResponse response, Object obj) {
        JSONObject json = new JSONObject();
        json.put("success", (Object)this.success);
        json.put("msg", (Object)this.message);
        json.put("obj", obj);
        this.doSend(response, json.toJSONString());
    }

    public void sendResponseState(HttpServletResponse response, boolean success, Object obj) {
        JSONObject json = new JSONObject();
        json.put("success", (Object)success);
        json.put("msg", (Object)this.message);
        json.put("obj", obj);
        this.doSend(response, json.toJSONString());
    }

    public JSONObject returnJson() {
        JSONObject json = new JSONObject();
        json.put("success", (Object)this.success);
        json.put("msg", (Object)this.message);
        return json;
    }

    public String returnJsonString() {
        return this.returnJson().toJSONString();
    }

    public JSONObject returnJson(Object obj) {
        JSONObject json = new JSONObject();
        json.put("success", (Object)this.success);
        json.put("msg", (Object)this.message);
        json.put("obj", obj);
        return json;
    }

    public JSONObject returnJson(JSONObject json) {
        json.put("success", (Object)true);
        json.put("msg", (Object)this.message);
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSend(HttpServletResponse response, String json) {
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "no-store");
        PrintWriter pw = null;
        try {
            pw = response.getWriter();
            pw.write(json);
            pw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                json = "";
                this.message = "\u64cd\u4f5c\u6210\u529f";
                pw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected <T> void doExportXls(HttpServletResponse response, HttpServletRequest request, Collection<?> dataSet, Class<?> pojoClass, String title) {
        response.setContentType("application/vnd.ms-excel");
        OutputStream fOut = null;
        try {
            if (BrowserUtils.isIE(request)) {
                response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(title, "UTF-8") + ".xls");
            } else {
                String newtitle = new String(title.getBytes("UTF-8"), "ISO8859-1");
                response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
            }
            HSSFWorkbook workbook = null;
            ExcelTitle excelTitle = new ExcelTitle(title, "\u5bfc\u51fa\u4eba:" + this.resourceRpcService.getSessionUserName().getFullName(), "\u5bfc\u51fa\u4fe1\u606f");
            workbook = ExcelExportUtil.exportExcel(excelTitle, pojoClass, dataSet);
            fOut = response.getOutputStream();
            workbook.write(fOut);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        finally {
            try {
                if (fOut != null) {
                    fOut.flush();
                    fOut.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @ExceptionHandler
    public void exceptionHandler(Exception e, HttpServletRequest request, HttpServletResponse response) {
        e.printStackTrace();
        JSONObject json = new JSONObject();
        json.put("success", (Object)false);
        if (e instanceof BusinessException) {
            json.put("msg", (Object)((BusinessException)e).getMessage());
        } else {
            json.put("msg", (Object)e.getMessage());
        }
        this.doSend(response, json.toJSONString());
    }
}

