/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.exporter;

import com.biz.eisp.base.exporter.annotation.Excel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public final class ExcelUtil {
    private ExcelUtil() {
    }

    public static void createExcel(String excel_name, String[] headList, String[] fieldList, List<Map<String, Object>> dataList) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        HSSFRow row = sheet.createRow(0);
        for (int i = 0; i < headList.length; ++i) {
            HSSFCell cell = row.createCell(i);
            cell.setCellType(1);
            cell.setCellValue(headList[i]);
        }
        for (int n = 0; n < dataList.size(); ++n) {
            HSSFRow row_value = sheet.createRow(n + 1);
            Map<String, Object> dataMap = dataList.get(n);
            for (int i = 0; i < fieldList.length; ++i) {
                HSSFCell cell = row_value.createCell(i);
                cell.setCellType(1);
                cell.setCellValue(ExcelUtil.objToString(dataMap.get(fieldList[i])));
            }
        }
        FileOutputStream fOut = new FileOutputStream(excel_name);
        workbook.write((OutputStream)fOut);
        fOut.flush();
        fOut.close();
    }

    public static void createExcel(String excel_name, List<String> headList, List<String> fieldList, List<Map<String, Object>> dataList) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        HSSFRow row = sheet.createRow(0);
        for (int i = 0; i < headList.size(); ++i) {
            HSSFCell cell = row.createCell(i);
            cell.setCellType(1);
            cell.setCellValue(headList.get(i));
        }
        for (int n = 0; n < dataList.size(); ++n) {
            HSSFRow row_value = sheet.createRow(n + 1);
            Map<String, Object> dataMap = dataList.get(n);
            for (int i = 0; i < fieldList.size(); ++i) {
                HSSFCell cell = row_value.createCell(i);
                cell.setCellType(1);
                cell.setCellValue(ExcelUtil.objToString(dataMap.get(fieldList.get(i))));
            }
        }
        FileOutputStream fOut = new FileOutputStream(excel_name);
        workbook.write((OutputStream)fOut);
        fOut.flush();
        fOut.close();
    }

    public static HSSFWorkbook createExcel(List<String> headList, List<String> fieldList, List<Map<String, Object>> dataList) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        HSSFRow row = sheet.createRow(0);
        for (int i = 0; i < headList.size(); ++i) {
            HSSFCell cell = row.createCell(i);
            cell.setCellType(1);
            cell.setCellValue(headList.get(i));
        }
        if (dataList != null && !dataList.isEmpty()) {
            for (int n = 0; n < dataList.size(); ++n) {
                HSSFRow row_value = sheet.createRow(n + 1);
                Map<String, Object> dataMap = dataList.get(n);
                for (int i = 0; i < fieldList.size(); ++i) {
                    HSSFCell cell = row_value.createCell(i);
                    cell.setCellType(1);
                    cell.setCellValue(ExcelUtil.objToString(dataMap.get(fieldList.get(i))));
                }
            }
        }
        return workbook;
    }

    private static String objToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Date) {
            return null;
        }
        return obj.toString();
    }

    public static void bulidExcel(String excel_name, String[] headList, List<String[]> valueList) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        HSSFRow row = sheet.createRow(0);
        for (int i = 0; i < headList.length; ++i) {
            HSSFCell cell = row.createCell(i);
            cell.setCellType(1);
            cell.setCellValue(headList[i]);
        }
        for (int n = 0; n < valueList.size(); ++n) {
            HSSFRow row_value = sheet.createRow(n + 1);
            String[] valueArray = valueList.get(n);
            for (int i = 0; i < valueArray.length; ++i) {
                HSSFCell cell = row_value.createCell(i);
                cell.setCellType(1);
                cell.setCellValue(valueArray[i]);
            }
        }
        FileOutputStream fOut = new FileOutputStream(excel_name);
        workbook.write((OutputStream)fOut);
        fOut.flush();
        fOut.close();
    }

    public static List<String[]> readExcel(String excel_name) throws Exception {
        ArrayList<String[]> list = new ArrayList<String[]>();
        HSSFWorkbook hssfworkbook = new HSSFWorkbook((InputStream)new FileInputStream(excel_name));
        HSSFSheet hssfsheet = hssfworkbook.getSheetAt(0);
        for (int j = 0; j < hssfsheet.getPhysicalNumberOfRows(); ++j) {
            HSSFRow hssfrow = hssfsheet.getRow(j);
            if (hssfrow == null) continue;
            int col = hssfrow.getPhysicalNumberOfCells();
            String[] arrayString = new String[col];
            for (int i = 0; i < col; ++i) {
                HSSFCell cell = hssfrow.getCell(i);
                if (cell == null) {
                    arrayString[i] = "";
                    continue;
                }
                if (cell.getCellType() == 0) {
                    if (0 != cell.getCellType()) continue;
                    if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                        Date d = cell.getDateCellValue();
                        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        arrayString[i] = formater.format(d);
                        continue;
                    }
                    arrayString[i] = new BigDecimal(cell.getNumericCellValue()).longValue() + "";
                    continue;
                }
                arrayString[i] = cell.getStringCellValue().trim();
            }
            list.add(arrayString);
        }
        return list;
    }

    public static List<List<Object>> readExcelByList(String excel_name) throws Exception {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        HSSFWorkbook hssfworkbook = new HSSFWorkbook((InputStream)new FileInputStream(excel_name));
        HSSFSheet hssfsheet = hssfworkbook.getSheetAt(0);
        for (int j = 0; j < hssfsheet.getPhysicalNumberOfRows(); ++j) {
            HSSFRow hssfrow = hssfsheet.getRow(j);
            if (hssfrow == null) continue;
            int col = hssfrow.getPhysicalNumberOfCells();
            ArrayList<String> arrayString = new ArrayList<String>();
            for (int i = 0; i < col; ++i) {
                HSSFCell cell = hssfrow.getCell(i);
                if (cell == null) {
                    arrayString.add("");
                    continue;
                }
                if (cell.getCellType() == 0) {
                    arrayString.add(new Double(cell.getNumericCellValue()).toString());
                    continue;
                }
                arrayString.add(cell.getStringCellValue().trim());
            }
            list.add(arrayString);
        }
        return list;
    }

    public static List<List<Object>> readExcelByInputStream(InputStream inputstream) throws Exception {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        HSSFWorkbook hssfworkbook = new HSSFWorkbook(inputstream);
        HSSFSheet hssfsheet = hssfworkbook.getSheetAt(0);
        int col = hssfsheet.getRow(0).getPhysicalNumberOfCells();
        for (int j = 0; j < hssfsheet.getPhysicalNumberOfRows(); ++j) {
            HSSFCell terminalName;
            HSSFRow hssfrow = hssfsheet.getRow(j);
            if (hssfrow == null || (terminalName = hssfrow.getCell(0, HSSFRow.RETURN_BLANK_AS_NULL)) == null || terminalName.equals("") || terminalName.getCellType() == 3) continue;
            ArrayList<String> arrayString = new ArrayList<String>();
            for (int i = 0; i < col; ++i) {
                HSSFCell cell = hssfrow.getCell(i, HSSFRow.RETURN_BLANK_AS_NULL);
                if (cell == null || cell.equals("") || cell.getCellType() == 3) {
                    arrayString.add("");
                    continue;
                }
                cell.setCellType(1);
                if (cell.getCellType() == 0) {
                    arrayString.add(new Double(cell.getNumericCellValue()).toString());
                    continue;
                }
                arrayString.add(cell.getStringCellValue().trim());
            }
            list.add(arrayString);
        }
        return list;
    }

    @Deprecated
    public static Collection importExcel(File file, Class pojoClass) {
        try {
            FileInputStream in = new FileInputStream(file);
            return ExcelUtil.importExcelByIs(in, pojoClass);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static Collection importExcelByIs(InputStream inputstream, Class pojoClass) {
        ArrayList dist = new ArrayList();
        try {
            Field[] filed = pojoClass.getDeclaredFields();
            HashMap<String, Method> fieldSetMap = new HashMap<String, Method>();
            HashMap<String, Method> fieldSetConvertMap = new HashMap<String, Method>();
            for (int i = 0; i < filed.length; ++i) {
                Field f = filed[i];
                Excel excel = f.getAnnotation(Excel.class);
                if (excel == null) continue;
                String fieldname = f.getName();
                String setMethodName = "set" + fieldname.substring(0, 1).toUpperCase() + fieldname.substring(1);
                Method setMethod = pojoClass.getMethod(setMethodName, f.getType());
                fieldSetMap.put(excel.exportName(), setMethod);
                if (excel.importConvertSign() != 1) continue;
                StringBuffer setConvertMethodName = new StringBuffer("convertSet");
                setConvertMethodName.append(fieldname.substring(0, 1).toUpperCase());
                setConvertMethodName.append(fieldname.substring(1));
                Method getConvertMethod = pojoClass.getMethod(setConvertMethodName.toString(), String.class);
                fieldSetConvertMap.put(excel.exportName(), getConvertMethod);
            }
            HSSFWorkbook book = new HSSFWorkbook(inputstream);
            HSSFSheet sheet = book.getSheetAt(0);
            Iterator row = sheet.rowIterator();
            Row title = (Row)row.next();
            Iterator cellTitle = title.cellIterator();
            HashMap<Integer, String> titlemap = new HashMap<Integer, String>();
            int i = 0;
            while (cellTitle.hasNext()) {
                Cell cell = (Cell)cellTitle.next();
                String value = cell.getStringCellValue();
                titlemap.put(i, value);
                ++i;
            }
            while (row.hasNext()) {
                Row rown = (Row)row.next();
                Iterator cellbody = rown.cellIterator();
                Object tObject = pojoClass.newInstance();
                int k = 0;
                while (cellbody.hasNext()) {
                    Cell cell = (Cell)cellbody.next();
                    String titleString = (String)titlemap.get(k);
                    if (fieldSetMap.containsKey(titleString)) {
                        Method setMethod = (Method)fieldSetMap.get(titleString);
                        Type[] ts = setMethod.getGenericParameterTypes();
                        String xclass = ts[0].toString();
                        if (1 == cell.getCellType() && fieldSetConvertMap.containsKey(titleString)) {
                            ((Method)fieldSetConvertMap.get(titleString)).invoke(tObject, cell.getStringCellValue());
                        } else if (xclass.equals("class java.lang.String")) {
                            cell.setCellType(1);
                            setMethod.invoke(tObject, cell.getStringCellValue());
                        } else if (xclass.equals("class java.util.Date")) {
                            Date cellDate = null;
                            cellDate = 0 == cell.getCellType() ? cell.getDateCellValue() : ExcelUtil.stringToDate(cell.getStringCellValue());
                            setMethod.invoke(tObject, cellDate);
                        } else if (xclass.equals("class java.lang.Boolean")) {
                            boolean valBool = 4 == cell.getCellType() ? cell.getBooleanCellValue() : cell.getStringCellValue().equalsIgnoreCase("true") || !cell.getStringCellValue().equals("0");
                            setMethod.invoke(tObject, valBool);
                        } else if (xclass.equals("class java.lang.Integer")) {
                            Integer valInt = 0 == cell.getCellType() ? Integer.valueOf(new Double(cell.getNumericCellValue()).intValue()) : new Integer(cell.getStringCellValue());
                            setMethod.invoke(tObject, valInt);
                        } else if (xclass.equals("class java.lang.Long")) {
                            Long valLong = 0 == cell.getCellType() ? Long.valueOf(new Double(cell.getNumericCellValue()).longValue()) : new Long(cell.getStringCellValue());
                            setMethod.invoke(tObject, valLong);
                        } else if (xclass.equals("class java.math.BigDecimal")) {
                            BigDecimal valDecimal = 0 == cell.getCellType() ? new BigDecimal(cell.getNumericCellValue()) : new BigDecimal(cell.getStringCellValue());
                            setMethod.invoke(tObject, valDecimal);
                        }
                    }
                    ++k;
                }
                dist.add(tObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return dist;
    }

    private static Date stringToDate(String cellValue) {
        if (cellValue.length() > 19) {
            cellValue = cellValue.substring(0, 19);
        }
        Calendar calendar = Calendar.getInstance();
        String[] dateStr = cellValue.split(" ");
        String[] dateInfo = dateStr[0].split("-");
        if (dateInfo.length != 3) {
            dateInfo = dateStr[0].split("/");
        }
        if (dateInfo.length != 3) {
            return null;
        }
        int year = Integer.parseInt(dateInfo[0]);
        int month = Integer.parseInt(dateInfo[1]) - 1;
        int day = Integer.parseInt(dateInfo[2]);
        calendar.set(year, month, day);
        if (dateStr.length > 1) {
            String[] timeStr = dateStr[1].split(":");
            if (timeStr.length == 3) {
                int hour = Integer.parseInt(timeStr[0]);
                int minute = Integer.parseInt(timeStr[1]);
                int second = Integer.parseInt(timeStr[2]);
                calendar.set(11, hour);
                calendar.set(12, minute);
                calendar.set(13, second);
            } else {
                return null;
            }
        }
        return calendar.getTime();
    }

    public static HSSFWorkbook createTerminalExcel(List<String> headList, List<String> headList2, List<String> fieldList, List<Map<String, Object>> dataList, List<String> headList3, List<String> fieldList2, List<Map<String, Object>> dataList2) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet("\u5bfc\u5165\u6570\u636e");
        HSSFRow row = sheet.createRow(0);
        for (int i = 0; i < headList.size(); ++i) {
            HSSFCell cell = row.createCell(i);
            cell.setCellType(1);
            cell.setCellValue(headList.get(i));
        }
        HSSFSheet sheet1 = workbook.createSheet("\u7701\u5e02\u533a\u5bf9\u7167\u8868");
        HSSFRow row1 = sheet1.createRow(0);
        for (int i = 0; i < headList2.size(); ++i) {
            HSSFCell cell = row1.createCell(i);
            cell.setCellType(1);
            cell.setCellValue(headList2.get(i));
        }
        if (dataList != null && !dataList.isEmpty()) {
            for (int n = 0; n < dataList.size(); ++n) {
                HSSFRow row_value = sheet1.createRow(n + 1);
                Map<String, Object> dataMap = dataList.get(n);
                for (int i = 0; i < fieldList.size(); ++i) {
                    HSSFCell cell = row_value.createCell(i);
                    cell.setCellType(1);
                    cell.setCellValue(ExcelUtil.objToString(dataMap.get(fieldList.get(i))));
                }
            }
        }
        HSSFSheet sheet2 = workbook.createSheet("\u6e20\u9053\u7f16\u7801\u5bf9\u7167\u8868");
        HSSFRow row2 = sheet2.createRow(0);
        for (int i = 0; i < headList3.size(); ++i) {
            HSSFCell cell = row2.createCell(i);
            cell.setCellType(1);
            cell.setCellValue(headList3.get(i));
        }
        if (dataList2 != null && !dataList2.isEmpty()) {
            for (int n = 0; n < dataList2.size(); ++n) {
                HSSFRow row_value = sheet2.createRow(n + 1);
                Map<String, Object> dataMap = dataList2.get(n);
                for (int i = 0; i < fieldList2.size(); ++i) {
                    HSSFCell cell = row_value.createCell(i);
                    cell.setCellType(1);
                    cell.setCellValue(ExcelUtil.objToString(dataMap.get(fieldList2.get(i))));
                }
            }
        }
        return workbook;
    }
}

