/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.utils;

import com.biz.eisp.base.common.exception.BusinessException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesCryptographer {
    public static final String ENCODING = "UTF-8";
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_ALGORITHM_CBC = "AES/CBC/PKCS5Padding";
    private static ThreadLocal<Cipher> cipherThreadLocal = new ThreadLocal();

    public byte[] encrypt(byte[] content, String password, String ivParam) throws BusinessException {
        try {
            Cipher cipher = this.getCipher();
            cipher.init(1, (Key)this.getAesSecretKeySpec(password), new IvParameterSpec(ivParam.getBytes(ENCODING)));
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new BusinessException(e);
        }
    }

    public byte[] encrypt(String content, String password, String ivParam) throws BusinessException {
        try {
            return this.encrypt(content.getBytes(ENCODING), password, ivParam);
        }
        catch (Exception e) {
            throw new BusinessException(e);
        }
    }

    public byte[] decrypt(byte[] encryptedContent, String password, String ivParam) throws BusinessException {
        try {
            Cipher cipher = this.getCipher();
            cipher.init(2, (Key)this.getAesSecretKeySpec(password), new IvParameterSpec(ivParam.getBytes(ENCODING)));
            return cipher.doFinal(encryptedContent);
        }
        catch (Exception e) {
            throw new BusinessException(e);
        }
    }

    private Cipher getCipher() {
        if (cipherThreadLocal.get() == null) {
            try {
                cipherThreadLocal.set(Cipher.getInstance(CIPHER_ALGORITHM_CBC));
            }
            catch (Exception e) {
                throw new BusinessException(e);
            }
        }
        return cipherThreadLocal.get();
    }

    private SecretKeySpec getAesSecretKeySpec(String password) throws UnsupportedEncodingException {
        return new SecretKeySpec(password.getBytes(ENCODING), KEY_ALGORITHM);
    }
}

