/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.es.service.impl;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.es.esentity.BaseESO;
import com.biz.eisp.es.esrepository.BaseElasticsearchRepository;
import com.biz.eisp.es.service.BaseElasticSearchService;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;

public abstract class BaseElasticSearchServiceImpl<ESO extends BaseESO, E extends IdEntity>
implements BaseElasticSearchService<ESO, E> {
    protected BaseElasticsearchRepository<ESO> elasticsearchRepository;
    protected ElasticsearchTemplate elasticsearchTemplate;

    public <T extends BaseElasticsearchRepository<ESO>> BaseElasticSearchServiceImpl(T elasticsearchRepository, ElasticsearchTemplate elasticsearchTemplate) {
        this.elasticsearchRepository = elasticsearchRepository;
        this.elasticsearchTemplate = elasticsearchTemplate;
    }

    @Override
    public void save(E e) {
        ESO eso = this.apply(e);
        this.elasticsearchRepository.save(eso);
    }

    @Override
    public void save(List<E> es) {
        List esos = Lists.transform(es, (Function)this);
        this.elasticsearchRepository.save(esos);
    }

    @Override
    public void delete(String esId) {
        this.elasticsearchRepository.delete((Serializable)((Object)esId));
    }

    public ESO apply(E e) {
        Class esoClass = this.elasticsearchRepository.getEntityClass();
        BaseESO eso = null;
        try {
            eso = (BaseESO)esoClass.newInstance();
            MyBeanUtils.copyBean2Bean(eso, e);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
        return (ESO)eso;
    }
}

