/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.es.service.impl;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.base.utils.UUIDGenerator;
import com.biz.eisp.es.esentity.BaseLogable;
import com.biz.eisp.es.esrepository.BaseElasticsearchRepository;
import com.biz.eisp.es.service.BaseLogableService;
import com.biz.eisp.es.service.impl.BaseElasticSearchServiceImpl;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;

public abstract class BaseLogableServiceImpl<ESO extends BaseLogable, E extends IdEntity>
extends BaseElasticSearchServiceImpl<ESO, E>
implements BaseLogableService<ESO, E> {
    public <T extends BaseElasticsearchRepository<ESO>> BaseLogableServiceImpl(T elasticsearchRepository, ElasticsearchTemplate elasticsearchTemplate) {
        super(elasticsearchRepository, elasticsearchTemplate);
    }

    @Override
    public List<ESO> findByDBId(String dbid) {
        if (StringUtils.isEmpty((String)dbid)) {
            return Collections.emptyList();
        }
        List esos = this.elasticsearchTemplate.queryForList(this.buildDBIdQuery(dbid, null, null), this.elasticsearchRepository.getEntityClass());
        return esos;
    }

    @Override
    public Page<ESO> findByDBId(String dbid, Integer currentPage, Integer pageSize) {
        if (StringUtils.isEmpty((String)dbid)) {
            return null;
        }
        Page search = this.elasticsearchRepository.search(this.buildDBIdQuery(dbid, currentPage, pageSize));
        return search;
    }

    protected SearchQuery buildDBIdQuery(String dbid, Integer currentPage, Integer pageSize) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        TermQueryBuilder dbidQuery = QueryBuilders.termQuery((String)"dbId", (String)dbid);
        boolQueryBuilder.must((QueryBuilder)dbidQuery);
        PageRequest pageable = currentPage != null && pageSize != null ? new PageRequest(currentPage.intValue(), pageSize.intValue(), new Sort(Sort.Direction.DESC, new String[]{"changeDate"})) : null;
        FieldSortBuilder sortBuilder = SortBuilders.fieldSort((String)"changeDate").order(SortOrder.DESC);
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).withSort((SortBuilder)sortBuilder);
        if (pageable != null) {
            nativeSearchQueryBuilder.withPageable((Pageable)pageable);
        }
        return nativeSearchQueryBuilder.build();
    }

    @Override
    public ESO apply(E e) {
        BaseLogable eso = (BaseLogable)super.apply(e);
        if (eso != null) {
            eso.setDbId(((IdEntity)e).getId());
            eso.setId(UUIDGenerator.generate());
            eso.setChangeDate(new Date());
        }
        return (ESO)eso;
    }
}

