package com.chinayanghe.msp.mdm.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by isshu on 2017/7/31.
 */
public enum ActivitiState {

    // 流程实例基础对象的状态(审批中,驳回,已撤销  这三个状态数据不能操作)
    ACT_BASE_STATUS_DRAFT(0,"草稿"),ACT_BASE_STATUS_SAVE(1,"暂存"), ACT_BASE_STATUS_DOING(2, "审批中"),
    ACT_BASE_STATUS_FINISH(3, "已完成"),ACT_BASE_STATUS_REJECT(4, "驳回"),ACT_BASE_STATUS_END(5, "终止,审批不通过"),
    ACT_BASE_STATUS_CANCEL(6, "已撤销");

    private static final Map<Integer,ActivitiState> objMap = new HashMap();

    public static ActivitiState getObjByCode(Integer code){

        if(objMap.isEmpty()){

            ActivitiState[] values = ActivitiState.values();
            for (ActivitiState obj : values) {

                objMap.put(obj.getCode(),obj);
            }
        }
        return objMap.get(code);
    }

    private int code;
    private String desc;
    ActivitiState(int code,String desc){

        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
