package com.chinayanghe.msp.mdm.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * SFA APP 角色
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/6/22
 */
public enum SFAAppRoles {

    SALE_ROLE("传统渠道","saleRole", Arrays.asList(OrgType.REGION),Arrays.asList("003","004","005001"),AppRoleOrgDiffType.BOTH,"005"),

    INSPECTION_ROLE("现代渠道","inspectionRole",null,Arrays.asList("005002"),AppRoleOrgDiffType.ORG_CODE,""),

    JUDGE_ROLE("市场部角色","judgeRole",null,Arrays.asList("006003"),AppRoleOrgDiffType.ORG_CODE,""),

    FRANCHISER_ROLE("销售部角色","franchiserRole",null,Arrays.asList("017"),AppRoleOrgDiffType.ORG_CODE,""),

    ALL_JURISDICTION("总经理","allJurisdiction",null,new ArrayList<>(),AppRoleOrgDiffType.ORG_CODE,"01")
    ;
    private String roleName;

    private String roleCode;

    private List<OrgType> orgTypes;

    private List<String> orgCodes;

    private AppRoleOrgDiffType diffType;

    private String singleOrgCode;

    public String getSingleOrgCode() {
        return singleOrgCode;
    }
    public String getRoleName() {
        return roleName;
    }

    public String getRoleCode() {
        return roleCode;
    }

    public List<OrgType> getOrgTypes() {
        return orgTypes;
    }

    public List<String> getOrgCodes() {
        return orgCodes;
    }

    public AppRoleOrgDiffType getDiffType() {
        return diffType;
    }

    SFAAppRoles(String roleName, String roleCode, List<OrgType> orgTypes, List<String> orgCodes, AppRoleOrgDiffType diffType,String singleOrgCode) {
        this.roleName = roleName;
        this.roleCode = roleCode;
        this.orgTypes = orgTypes;
        this.orgCodes = orgCodes;
        this.diffType = diffType;
        this.singleOrgCode = singleOrgCode;
    }

    public static final String SFA_POSITION_ROLE_SYNC_QUEUE_NAME = "sfa.role.position.sync.queue";

    public enum AppRoleOrgDiffType{
        ORG_TYPE,ORG_CODE,BOTH
    }

    public static SFAAppRoles getSfaAppRoleByOrgCode(String orgCode,String currOrgCode){
        if(orgCode == null || orgCode.length() == 0){
            return null;
        }
        SFAAppRoles[] values = SFAAppRoles.values();
        for(SFAAppRoles r :values){
            if(r.orgCodes.contains(orgCode) || r.getSingleOrgCode().equals(currOrgCode)){
                return r;
            }
        }
        return null;
    }
}
