package com.chinayanghe.msp.mdm.rpc.autho;

/**
 * eisp通用权限service
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/9/6
 */
public interface MdmEispAuthService {

    /**
     * 岗位是否拥有指定角色中某一个角色
     * @param positionCode 岗位编码
     * @param roleCodes 角色编码
     * @return
     */
    boolean hasRole(String positionCode,String[] roleCodes);

    /**
     * 判断岗位是否拥有权限操作按钮
     * functionId、requestUri、requestReferer。不能均为空,优先级:functionId&gt;requestReferer&gt;requestUri
     * @param positionCode 岗位编码
     * @param functionId 连接菜单id
     * @param requestUri 请求uri
     * @param requestReferer 来源地址
     * @param operationCodes 操作按钮/页面区域编码
     * @return
     */
    boolean hasOperationButtonPower(String positionCode,String functionId,String requestUri,String requestReferer,String[] operationCodes);
}
