package com.chinayanghe.msp.mdm.vo.terminal.req;


import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.chinayanghe.msp.mdm.constant.NotNull;
import com.chinayanghe.msp.mdm.vo.terminal.TerminalLinkManVo;

/** 
 * 终端基础信息dto
 * @author shu
 * @version v1.0
 */
public class TmTerminalReqVo implements Serializable {


	private static final long serialVersionUID = 8962821796238564165L;
	private String id;
	/** 数据版本(默认值是0)*/
	private Integer version;
	/** 审批类型（新增，修改，启，停）SfaProcessType*/
	private Integer auditType;
	/**
	 * 终端编码
	 */
	@NotNull
	private String terminalCode;
	/**
	 * 终端名称
	 */
	@NotNull
	private String terminalName;
	/**
	 * 终端类型
	 * 01：核心  02：非核心
	 */
	@NotNull
	private String terminalType;
	/**
	 * 渠道类型
	 */
	@NotNull
	private String channelType;
	/**
	 * 省
	 */
	@NotNull
	private String province;
	/**
	 * 市
	 */
	@NotNull
	private String city;
	/**
	 * 区
	 */
	@NotNull
	private String area;
	/**
	 * 乡镇编码
	 */
	private String towns;
	/**
	 * 收货地址
	 */
	@NotNull
	private String address;
	/**
	 * 终端联系人
	 */
	private List<TerminalLinkManVo> terminalLinkManVos;
	/**
	 * 数据审批状态
	 */
	private String auditStatus;
	/**
	 * 启用状态：0-启用
	 */
	private Integer enableStatus;
	/**
	 * 创建时间
	 */
	@NotNull
	private Date createDate;
	/**
	 * 创建用户账号
	 */
	@NotNull
	private String createName;
	/**
	 * 修改时间
	 */
	@NotNull
	private Date updateDate;
	/**
	 * 修改用户账号
	 */
	@NotNull
	private String updateName;

	/**
     * 经度
	 */
	@NotNull
	private String longitude;
	/**
     * 纬度
	 */
	@NotNull
	private String latitude;

	/** 创建岗位*/
	@NotNull
	private String positionCode;
	/** 更新岗位*/
	@NotNull
	private String positionCodeUp;

	/**
	 * 营业执照编码
	 * 字符类型（length=100）-扩展字段1
	 */
	/*@NotNull*/
	private String extChar1;
	/**
	 * 营业执照照片
	 * 字符类型（length=100）-扩展字段2
	 */
	/*@NotNull*/
	private String extChar2;
	/**
	 * 门头照片（逗号分隔有多张）
	 * 字符类型（length=100）-扩展字段3
	 */
	@NotNull
	private String extChar3;
	/**
	 * 终端来源编码
	 * 01：系统导入    02：业务员录入    03：终端自主注册
	 * 字符类型（length=100）-扩展字段4
	 */
	@NotNull
	private String extChar4;
	/**
	 * 拜访状态编码
	 * 01：存在拜访记录    02：从未拜访
	 * 字符类型（length=100）-扩展字段5
	 */
	private String extChar5;
	/**
	 * 督查状态编码
	 * 01：已督查   02：从未督查
	 * 字符类型（length=200）-扩展字段6
	 */
	@NotNull
	private String extChar6;
	/**
	 * 开户银行
	 * 字符类型（length=200）-扩展字段7
	 */
	private String extChar7;
	/**
	 * 银行开户名
	 * 字符类型（length=200）-扩展字段8
	 */
	private String extChar8;
	/**
	 * 银行账号
	 * 字符类型（length=200）-扩展字段9
	 */
	private String extChar9;
	/**
	 * 身份证号
	 * 字符类型（length=200）-扩展字段10
	 */
	@NotNull
	private String extChar10;
	/**
	 * qq号
	 * 字符类型（length=1000）-扩展字段11
	 */
	private String extChar11;
	/**
	 * 微信号
	 * 字符类型（length=1000）-扩展字段12
	 */
	private String extChar12;
	/**
	 * 字符类型（length=1000）-扩展字段13
	 * 备注
	 */
	private String extChar13;
	/**
	 * 字符类型（length=1000）-扩展字段14
	 * 启停原因
	 */
	private String extChar14;

	/**
	 * 字符类型（length=1000）-扩展字段15
	 * 省名
	 */
	@NotNull
	private String extChar15;
	/**
	 * 字符类型（length=500）-扩展字段16
	 * 市名
	 */
	@NotNull
	private String extChar16;
	/**
	 * 字符类型（length=500）-扩展字段17
	 * 区名
	 */
	@NotNull
	private String extChar17;

	/**
	 * 详细地址
	 */
	@NotNull
	private String extChar18;
	
	//向终端组推送数据是否成功（每晚定时任务 再次推送失败的数据）失败0，成功1
	private Integer pushFlag;

	private String franchiserCode;

	private String franchiserName;

	public String getFranchiserCode() {
		return franchiserCode;
	}

	public void setFranchiserCode(String franchiserCode) {
		this.franchiserCode = franchiserCode;
	}

	public String getFranchiserName() {
		return franchiserName;
	}

	public void setFranchiserName(String franchiserName) {
		this.franchiserName = franchiserName;
	}

	public String getTerminalCode() {
		return terminalCode;
	}

	public void setTerminalCode(String terminalCode) {
		this.terminalCode = terminalCode;
	}

	public String getTerminalName() {
		return terminalName;
	}

	public void setTerminalName(String terminalName) {
		this.terminalName = terminalName;
	}

	public String getTerminalType() {
		return terminalType;
	}

	public void setTerminalType(String terminalType) {
		this.terminalType = terminalType;
	}

	public String getChannelType() {
		return channelType;
	}

	public void setChannelType(String channelType) {
		this.channelType = channelType;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public List<TerminalLinkManVo> getTerminalLinkManVos() {
		return terminalLinkManVos;
	}

	public void setTerminalLinkManVos(List<TerminalLinkManVo> terminalLinkManVos) {
		this.terminalLinkManVos = terminalLinkManVos;
	}

	public Date getCreateDate() {
		return createDate;
	}

	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	public String getCreateName() {
		return createName;
	}

	public void setCreateName(String createName) {
		this.createName = createName;
	}

	public Date getUpdateDate() {
		return updateDate;
	}

	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

	public String getUpdateName() {
		return updateName;
	}

	public void setUpdateName(String updateName) {
		this.updateName = updateName;
	}

	public String getLongitude() {
		return longitude;
	}

	public void setLongitude(String longitude) {
		this.longitude = longitude;
	}

	public String getLatitude() {
		return latitude;
	}

	public void setLatitude(String latitude) {
		this.latitude = latitude;
	}

	public String getPositionCode() {
		return positionCode;
	}

	public void setPositionCode(String positionCode) {
		this.positionCode = positionCode;
	}

	public String getPositionCodeUp() {
		return positionCodeUp;
	}

	public void setPositionCodeUp(String positionCodeUp) {
		this.positionCodeUp = positionCodeUp;
	}

	public String getExtChar1() {
		return extChar1;
	}

	public void setExtChar1(String extChar1) {
		this.extChar1 = extChar1;
	}

	public String getExtChar2() {
		return extChar2;
	}

	public void setExtChar2(String extChar2) {
		this.extChar2 = extChar2;
	}

	public String getExtChar3() {
		return extChar3;
	}

	public void setExtChar3(String extChar3) {
		this.extChar3 = extChar3;
	}

	public String getExtChar4() {
		return extChar4;
	}

	public void setExtChar4(String extChar4) {
		this.extChar4 = extChar4;
	}

	public String getExtChar5() {
		return extChar5;
	}

	public void setExtChar5(String extChar5) {
		this.extChar5 = extChar5;
	}

	public String getExtChar6() {
		return extChar6;
	}

	public void setExtChar6(String extChar6) {
		this.extChar6 = extChar6;
	}

	public String getExtChar7() {
		return extChar7;
	}

	public void setExtChar7(String extChar7) {
		this.extChar7 = extChar7;
	}

	public String getExtChar8() {
		return extChar8;
	}

	public void setExtChar8(String extChar8) {
		this.extChar8 = extChar8;
	}

	public String getExtChar9() {
		return extChar9;
	}

	public void setExtChar9(String extChar9) {
		this.extChar9 = extChar9;
	}

	public String getExtChar10() {
		return extChar10;
	}

	public void setExtChar10(String extChar10) {
		this.extChar10 = extChar10;
	}

	public String getExtChar11() {
		return extChar11;
	}

	public void setExtChar11(String extChar11) {
		this.extChar11 = extChar11;
	}

	public String getExtChar12() {
		return extChar12;
	}

	public void setExtChar12(String extChar12) {
		this.extChar12 = extChar12;
	}

	public String getExtChar13() {
		return extChar13;
	}

	public void setExtChar13(String extChar13) {
		this.extChar13 = extChar13;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getTowns() {
		return towns;
	}

	public void setTowns(String towns) {
		this.towns = towns;
	}

	public String getAuditStatus() {
		return auditStatus;
	}

	public void setAuditStatus(String auditStatus) {
		this.auditStatus = auditStatus;
	}

	public Integer getEnableStatus() {
		return enableStatus;
	}

	public void setEnableStatus(Integer enableStatus) {
		this.enableStatus = enableStatus;
	}

	public String getExtChar14() {
		return extChar14;
	}

	public void setExtChar14(String extChar14) {
		this.extChar14 = extChar14;
	}

	public String getExtChar15() {
		return extChar15;
	}

	public void setExtChar15(String extChar15) {
		this.extChar15 = extChar15;
	}

	public String getExtChar16() {
		return extChar16;
	}

	public void setExtChar16(String extChar16) {
		this.extChar16 = extChar16;
	}

	public String getExtChar17() {
		return extChar17;
	}

	public void setExtChar17(String extChar17) {
		this.extChar17 = extChar17;
	}

	public Integer getVersion() {
		return version;
	}

	public void setVersion(Integer version) {
		this.version = version;
	}

	public Integer getAuditType() {
		return auditType;
	}

	public void setAuditType(Integer auditType) {
		this.auditType = auditType;
	}

	public String getExtChar18() {
		return extChar18;
	}

	public void setExtChar18(String extChar18) {
		this.extChar18 = extChar18;
	}

	public Integer getPushFlag() {
		return pushFlag;
	}

	public void setPushFlag(Integer pushFlag) {
		this.pushFlag = pushFlag;
	}

}
