package com.chinayanghe.msp.mdm.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by isshu on 2017/6/14.
 * 终端渠道类型
 */
public enum ChannelType {

    hotel("11","特通渠道"),
    superChain("12","合作伙伴"),
    ESHOP("14","传统渠道"),
    groupBuyChannel("50","餐饮渠道"),
    OTHER("60","现代渠道");

    private String code;
    private String desc;

    public static final Map<String,ChannelType> objMap = new HashMap<>();

    public static ChannelType getObj(String code){

        if(objMap.isEmpty()){

            ChannelType[] values = ChannelType.values();
            for (ChannelType channelType : values
                    ) {

                objMap.put(channelType.getCode(),channelType);
            }
        }
        return objMap.get(code);
    }

    ChannelType(String code, String desc){

        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
