package com.chinayanghe.msp.mdm.enums;

/**
 * 岗位与经销商关系职责
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/4/26
 */
public enum PositionFranchiseDuty{

    SALE("销售",0),
    COST("费用",1),
    FINANCE("财务",2)
    ;

    /**
     * 描述
     */
    private String desc;

    private int value;

    PositionFranchiseDuty(String desc, int value) {
        this.desc = desc;
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public static PositionFranchiseDuty fromValue(int value){
        switch (value){
            case 0:
                return SALE;
            case 1:
                return COST;
            case 2:
                return FINANCE;
            default:
                return null;
        }
    }

}
