package com.chinayanghe.msp.mdm.rpc.region;

import com.chinayanghe.msp.mdm.exception.BusinessException;
import com.chinayanghe.msp.mdm.vo.region.RegionVo;

import java.util.List;


/**
 * Created by Administrator on 2017/5/11 0011.
 */
public interface RegionRpcService {
    /**
     * 获取区域信息.
     * <p>根据区域编码获取有效的区域集合信息,为空返回所有
     * @author grover
     * @return 区域集合
     * @throws BusinessException 运行过程中可能出现的异常
     */
    public List<RegionVo> getRegionByRegionCode(String code);
    /**
     * 获取下级区域信息.
     * <p>根据区域编码获取其对应的下级区域信息
     * @author grover
     * @return 区域集合
     * @throws BusinessException 运行过程中可能出现的异常
     */
    public List<RegionVo> getChildrenByRegionCode(String code);
    /**
     * 获取一级区域信息.(省)
     * @author grover
     * @return 区域集合
     * @throws BusinessException 运行过程中可能出现的异常
     */
    public List<RegionVo> getProvinceInformation();

    /**
     * 根据区域等级查询
     * @param areaLevels 1：省；2：市；3：区县；4：乡镇；
     * @return
     */
    List<RegionVo> findByAreaLevel(String... areaLevels);

    /**
     * 查找所有子区域并封装树形关系
     * @param regionCode
     * @return
     */
    List<RegionVo> findChildRegionsWithTreeRelation(String regionCode);

    /**
     * 查找区域树形路径
     * @param regionCode
     * @return
     */
    RegionVo findRegionTopTreePath(String regionCode);

    /**
     * 查找所有省市区，并封装树形结构
     * @return
     */
    List<RegionVo> findAllRegionWithTreeRelation();

    /**
     * 查询最佳匹配的区域
     * @param provinceName 省名称
     * @param cityName 市名称
     * @param distractName 区县名称
     * @param townName 乡镇名称
     * @return
     */
    RegionVo findMostLikeRegionRelation(String provinceName,String cityName,String distractName,String townName);
}
