package com.chinayanghe.msp.mdm.rpc.sync;

import com.chinayanghe.msp.mdm.annotations.FullSyncMethodDefine;
import com.chinayanghe.msp.mdm.annotations.SyncDefineInterface;
import com.chinayanghe.msp.mdm.enums.SFAAppRoles;
import com.chinayanghe.msp.mdm.vo.org.OrgBasicInformationVo;
import com.chinayanghe.msp.mdm.vo.position.PositionInformationVo;
import com.chinayanghe.msp.mdm.vo.position.PositionRoleVo;
import com.chinayanghe.msp.mdm.vo.role.RoleBasicInformationVo;
import com.chinayanghe.msp.mdm.vo.sync.MasterDataSynVo;
import com.chinayanghe.msp.mdm.vo.sync.MenuFunctionVo;
import com.chinayanghe.msp.mdm.vo.sync.RoleMenuRelationVo;
import com.chinayanghe.msp.mdm.vo.user.UserBasicInformationVo;
import com.chinayanghe.msp.mdm.vo.user.UserPositionVo;

import java.util.List;

/**
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/7/26
 */
public interface DataSyncRpcService extends SyncDefineInterface{

//    @FullSyncMethodDefine(syncId = "syncFranchiser2Eso",desc = "全量同步经销商到es")
    void syncFranchiser2Eso();

//    @FullSyncMethodDefine(syncId = "syncFranchiseProtocol2Eso",desc = "全量同步经销商协议到es(请先同步产品)")
    void syncFranchiseProtocol2Eso();

//    @FullSyncMethodDefine(syncId = "syncOrg2ES",desc = "全量同步组织到es")
    void syncOrg2ES();

    @FullSyncMethodDefine(syncId = "updatePositionSfaRole",desc = "全量更新sfa角色")
    void updatePositionSfaRole();

//    @FullSyncMethodDefine(syncId = "syncProductSaleEso",desc = "全量同步产品到es")
    void syncProductSaleEso();

//    @FullSyncMethodDefine(syncId = "syncAllRegions2es",desc = "全量同步省市区到es")
    void syncAllRegions2es();

//    @FullSyncMethodDefine(syncId = "syncAllTerminal2es",desc = "全量同步终端信息到es")
    void syncAllTerminal2es();

    /**
     * 同步组织下所有终端(暂只支持51，52层级同步)
     * @param orgCode
     */
    void syncAllTerminalByOrgCode(String orgCode);
    
    String syncMasterDataTOPortal(String opt);
    
    /**
     * eisp用户主数据操作同步
     * @param method 主数据类型 MasterDataSyncMethod
     * @param optFlag 操作类型 MasterDataSyncOpt
     * @param vo
     */
    void syncMdmUserToPortal(String method,String optFlag,UserBasicInformationVo vo);
    /**
     * eisp岗位主数据同步
     * @param method 主数据类型 MasterDataSyncMethod
     * @param optFlag 操作类型 MasterDataSyncOpt
     * @param vo
     */
    void syncMdmPositionToPortal(String method,String optFlag,PositionInformationVo vo);
    
    /**
     * eisp角色主数据同步
     * @param method 主数据类型 MasterDataSyncMethod
     * @param optFlag 操作类型 MasterDataSyncOpt
     * @param vo
     */
    void syncMdmRoleToPortal(String method,String optFlag,RoleBasicInformationVo vo);
    
    /**
     * eisp组织主数据同步
     * @param method 主数据类型 MasterDataSyncMethod
     * @param optFlag 操作类型 MasterDataSyncOpt
     * @param vo
     */
    void syncMdmOrgToPortal(String method,String optFlag,OrgBasicInformationVo vo);
    
    /**
     * eisp人岗关系同步
     * @param method 主数据类型 MasterDataSyncMethod
     * @param optFlag 操作类型 MasterDataSyncOpt
     * @param vo
     */
    void syncMdmUserPositionToPortal(String method,String optFlag,UserPositionVo vo);
    
    /**
     * eisp岗位角色关系同步
     * @param method 主数据类型 MasterDataSyncMethod
     * @param optFlag 操作类型 MasterDataSyncOpt
     * @param vo
     */
    void syncMdmPositionRoleToPortal(String method,String optFlag,PositionRoleVo vo);
    
    /**
     * eisp菜单同步
     * @param method 主数据类型 MasterDataSyncMethod
     * @param optFlag 操作类型 MasterDataSyncOpt
     * @param vo
     */
    void syncMdmMenuToPortal(String method,String optFlag,MenuFunctionVo vo);
    
    /**
     * eisp角色菜单同步
     * @param method 主数据类型 MasterDataSyncMethod
     * @param optFlag 操作类型 MasterDataSyncOpt
     * @param vo
     */
    void syncMdmRoleMenuToPortal(String method,String optFlag,List<RoleMenuRelationVo> vo);
    
    /**
     * 主数据推Mq
     * @param masterDataSynVo
     */
    void syncMasterDataToPortal(MasterDataSynVo masterDataSynVo);
    
    
    /**
     * 同步访销岗位角色
     * @param positionCode
     * @param appRole
     */
    void syncSfaPosition(String positionCode,SFAAppRoles appRole);
}
