package com.chinayanghe.msp.mdm.vo.franchiser;

import com.chinayanghe.msp.mdm.vo.position.PositionInformationVo;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 经销商vo
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/4/18
 */
public class FranchiserVo implements Serializable {

    private static final long serialVersionUID = 1772782687507490918L;

    private String id;

    /***
     * 经销商编码
     */
    private String franchiserCode;

    /***
     * 经销商名称
     */
    private String franchiserName;

    /**
     * 经销商类型/称谓：
     * 公司/个人
     */
    private String franchiserType;

    /**
     * 渠道编码
     */
    private String channelCode;

    /**
     * 经销商渠道
     */
    private String channelName;

    /**
     * 资金能力
     */
    private String bankrollLevel;

    /**
     * 客户类型编码
     */
    private String customerTypeCode;

    /**
     * 客户类型名称
     */
    private String customerTypeName;

    /**
     * 主客户编码:
     * 子客户和主客户共用一个经销商协议，在费用申请和经销商下单时使用
     */
    private String masterCustomerCode;

    /**
     * 冻结状态 1表示冻结 其他或空值表示未冻结
     */
    private Integer status;

    /**
     * SAP创建时间
     */
    private Date createDate;

    /**
     * 创建用户
     * SAP账号
     */
    private String createUsername;

    /**
     * 销售范围
     */
    private List<SaleRangeVo> saleRanges;

    /**
     * 经销商银行账号
     */
    private List<FranchiserBankVo> franchiserBanks;

    /**
     * 经销商联系人
     */
    private List<FranchiserContactsVo> franchiserContacts;


    /**
     * 区域
     */
    private List<FranchiserPrefectureVo> FranchiserPrefecture;

    public List<FranchiserPrefectureVo> getFranchiserPrefecture() {
        return FranchiserPrefecture;
    }

    public void setFranchiserPrefecture(List<FranchiserPrefectureVo> franchiserPrefecture) {
        FranchiserPrefecture = franchiserPrefecture;
    }

    /**
     * 法人
     * @return
     */
    private String juridicalPersonName;

    /**
     * 法人固定电话
     * @return
     */
    private String juridicalPersonTel;

    /**
     * 法人手机号码
     * @return
     */
    private String juridicalPersonPhone;

    /**
     * 法人代表生日
     * @return
     */
    private Date juridicalPersonBirthday;

    /**
     * 法人代表爱好
     * @return
     */
    private String juridicalPersonInterest;

    /**
     * 法人籍贯
     * @return
     */
    private String juridicalPersonOrigin;

    /**
     * 发展日期
     * @return
     */
    private Date juridicalPersonDevelopmentDate;

    /**
     * 身份证编号
     * @return
     */
    private String juridicalPersonCardNo;


    /**
     * 企业类型
     * @return
     */
    private String businessEntities;

    /**
     * 企业税号
     * @return
     */
    private String businessTax;

    /**
     * 注册地址
     * @return
     */
    private String registeredAddress;
    /**
     * 经销商电话
     * @return
     */
    private String franchiserTelephone;
    /*dizhi*/
    private  String contactAddress;

    private List<PositionInformationVo> posRelations;


    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public List<PositionInformationVo> getPosRelations() {
        return posRelations;
    }

    public void setPosRelations(List<PositionInformationVo> posRelations) {
        this.posRelations = posRelations;
    }

    public String getContactAddress() {
        return contactAddress;
    }

    public void setContactAddress(String contactAddress) {
        this.contactAddress = contactAddress;
    }

    public String getBusinessEntities() {
        return businessEntities;
    }

    public void setBusinessEntities(String businessEntities) {
        this.businessEntities = businessEntities;
    }

    public String getBusinessTax() {
        return businessTax;
    }

    public void setBusinessTax(String businessTax) {
        this.businessTax = businessTax;
    }

    public String getRegisteredAddress() {
        return registeredAddress;
    }

    public void setRegisteredAddress(String registeredAddress) {
        this.registeredAddress = registeredAddress;
    }

    public String getFranchiserTelephone() {
        return franchiserTelephone;
    }

    public void setFranchiserTelephone(String franchiserTelephone) {
        this.franchiserTelephone = franchiserTelephone;
    }

    public String getJuridicalPersonName() {
        return juridicalPersonName;
    }

    public void setJuridicalPersonName(String juridicalPersonName) {
        this.juridicalPersonName = juridicalPersonName;
    }

    public String getJuridicalPersonTel() {
        return juridicalPersonTel;
    }

    public void setJuridicalPersonTel(String juridicalPersonTel) {
        this.juridicalPersonTel = juridicalPersonTel;
    }

    public String getJuridicalPersonPhone() {
        return juridicalPersonPhone;
    }

    public void setJuridicalPersonPhone(String juridicalPersonPhone) {
        this.juridicalPersonPhone = juridicalPersonPhone;
    }

    public Date getJuridicalPersonBirthday() {
        return juridicalPersonBirthday;
    }

    public void setJuridicalPersonBirthday(Date juridicalPersonBirthday) {
        this.juridicalPersonBirthday = juridicalPersonBirthday;
    }

    public String getJuridicalPersonInterest() {
        return juridicalPersonInterest;
    }

    public void setJuridicalPersonInterest(String juridicalPersonInterest) {
        this.juridicalPersonInterest = juridicalPersonInterest;
    }

    public String getJuridicalPersonOrigin() {
        return juridicalPersonOrigin;
    }

    public void setJuridicalPersonOrigin(String juridicalPersonOrigin) {
        this.juridicalPersonOrigin = juridicalPersonOrigin;
    }

    public Date getJuridicalPersonDevelopmentDate() {
        return juridicalPersonDevelopmentDate;
    }

    public void setJuridicalPersonDevelopmentDate(Date juridicalPersonDevelopmentDate) {
        this.juridicalPersonDevelopmentDate = juridicalPersonDevelopmentDate;
    }

    public String getJuridicalPersonCardNo() {
        return juridicalPersonCardNo;
    }

    public void setJuridicalPersonCardNo(String juridicalPersonCardNo) {
        this.juridicalPersonCardNo = juridicalPersonCardNo;
    }

    public String getFranchiserCode() {
        return franchiserCode;
    }

    public void setFranchiserCode(String franchiserCode) {
        this.franchiserCode = franchiserCode;
    }

    public String getFranchiserName() {
        return franchiserName;
    }

    public void setFranchiserName(String franchiserName) {
        this.franchiserName = franchiserName;
    }

    public String getFranchiserType() {
        return franchiserType;
    }

    public void setFranchiserType(String franchiserType) {
        this.franchiserType = franchiserType;
    }

    public String getBankrollLevel() {
        return bankrollLevel;
    }

    public void setBankrollLevel(String bankrollLevel) {
        this.bankrollLevel = bankrollLevel;
    }

    public String getCustomerTypeCode() {
        return customerTypeCode;
    }

    public void setCustomerTypeCode(String customerTypeCode) {
        this.customerTypeCode = customerTypeCode;
    }

    public String getCustomerTypeName() {
        return customerTypeName;
    }

    public void setCustomerTypeName(String customerTypeName) {
        this.customerTypeName = customerTypeName;
    }

    public String getMasterCustomerCode() {
        return masterCustomerCode;
    }

    public void setMasterCustomerCode(String masterCustomerCode) {
        this.masterCustomerCode = masterCustomerCode;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getCreateUsername() {
        return createUsername;
    }

    public void setCreateUsername(String createUsername) {
        this.createUsername = createUsername;
    }

    public List<SaleRangeVo> getSaleRanges() {
        return saleRanges;
    }

    public void setSaleRanges(List<SaleRangeVo> saleRanges) {
        this.saleRanges = saleRanges;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<FranchiserBankVo> getFranchiserBanks() {
        return franchiserBanks;
    }

    public void setFranchiserBanks(List<FranchiserBankVo> franchiserBanks) {
        this.franchiserBanks = franchiserBanks;
    }

    public List<FranchiserContactsVo> getFranchiserContacts() {
        return franchiserContacts;
    }

    public void setFranchiserContacts(List<FranchiserContactsVo> franchiserContacts) {
        this.franchiserContacts = franchiserContacts;
    }

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((customerTypeCode == null) ? 0 : customerTypeCode.hashCode());
		result = prime * result + ((customerTypeName == null) ? 0 : customerTypeName.hashCode());
		result = prime * result + ((franchiserCode == null) ? 0 : franchiserCode.hashCode());
		result = prime * result + ((franchiserName == null) ? 0 : franchiserName.hashCode());
		result = prime * result + ((franchiserType == null) ? 0 : franchiserType.hashCode());
		result = prime * result + ((masterCustomerCode == null) ? 0 : masterCustomerCode.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		FranchiserVo other = (FranchiserVo) obj;
		if (customerTypeCode == null) {
			if (other.customerTypeCode != null)
				return false;
		} else if (!customerTypeCode.equals(other.customerTypeCode))
			return false;
		if (customerTypeName == null) {
			if (other.customerTypeName != null)
				return false;
		} else if (!customerTypeName.equals(other.customerTypeName))
			return false;
		if (franchiserCode == null) {
			if (other.franchiserCode != null)
				return false;
		} else if (!franchiserCode.equals(other.franchiserCode))
			return false;
		if (franchiserName == null) {
			if (other.franchiserName != null)
				return false;
		} else if (!franchiserName.equals(other.franchiserName))
			return false;
		if (franchiserType == null) {
			if (other.franchiserType != null)
				return false;
		} else if (!franchiserType.equals(other.franchiserType))
			return false;
		if (masterCustomerCode == null) {
			if (other.masterCustomerCode != null)
				return false;
		} else if (!masterCustomerCode.equals(other.masterCustomerCode))
			return false;
		return true;
	}


}
