/*
 * Decompiled with CFR 0.152.
 */
package com.chinayanghe.msp.mdm.enums;

import com.chinayanghe.msp.mdm.enums.OrgType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum SFAAppRoles {
    SALE_ROLE("\u4f20\u7edf\u6e20\u9053", "saleRole", Arrays.asList(OrgType.REGION), Arrays.asList("003", "004", "005001", "00050009"), AppRoleOrgDiffType.BOTH, "005"),
    INSPECTION_ROLE("\u73b0\u4ee3\u6e20\u9053", "inspectionRole", null, Arrays.asList("005002"), AppRoleOrgDiffType.ORG_CODE, ""),
    JUDGE_ROLE("\u5e02\u573a\u90e8\u89d2\u8272", "judgeRole", null, Arrays.asList("006003"), AppRoleOrgDiffType.ORG_CODE, ""),
    FRANCHISER_ROLE("\u9500\u552e\u90e8\u89d2\u8272", "franchiserRole", null, Arrays.asList("017"), AppRoleOrgDiffType.ORG_CODE, ""),
    ALL_JURISDICTION("\u603b\u7ecf\u7406", "allJurisdiction", null, new ArrayList<String>(), AppRoleOrgDiffType.ORG_CODE, "01");

    private String roleName;
    private String roleCode;
    private List<OrgType> orgTypes;
    private List<String> orgCodes;
    private AppRoleOrgDiffType diffType;
    private String singleOrgCode;
    public static final String SFA_POSITION_ROLE_SYNC_QUEUE_NAME = "sfa.role.position.sync.queue";

    public String getSingleOrgCode() {
        return this.singleOrgCode;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getRoleCode() {
        return this.roleCode;
    }

    public List<OrgType> getOrgTypes() {
        return this.orgTypes;
    }

    public List<String> getOrgCodes() {
        return this.orgCodes;
    }

    public AppRoleOrgDiffType getDiffType() {
        return this.diffType;
    }

    private SFAAppRoles(String roleName, String roleCode, List<OrgType> orgTypes, List<String> orgCodes, AppRoleOrgDiffType diffType, String singleOrgCode) {
        this.roleName = roleName;
        this.roleCode = roleCode;
        this.orgTypes = orgTypes;
        this.orgCodes = orgCodes;
        this.diffType = diffType;
        this.singleOrgCode = singleOrgCode;
    }

    public static SFAAppRoles getSfaAppRoleByOrgCode(String orgCode, String currOrgCode) {
        SFAAppRoles[] values;
        if (orgCode == null || orgCode.length() == 0) {
            return null;
        }
        for (SFAAppRoles r : values = SFAAppRoles.values()) {
            if (!r.orgCodes.contains(orgCode) && !r.getSingleOrgCode().equals(currOrgCode)) continue;
            return r;
        }
        return null;
    }

    public static enum AppRoleOrgDiffType {
        ORG_TYPE,
        ORG_CODE,
        BOTH;

    }
}

