/*
 * Decompiled with CFR 0.152.
 */
package com.umpay.http;

import com.google.gson.Gson;
import com.umpay.mer.ConfigContext;
import com.umpay.util.RSAUtil;
import com.umpay.util.StringUtils;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UMFHttpClient {
    private static final Logger log = LoggerFactory.getLogger(UMFHttpClient.class);
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String CONTENT_TYPE_TEXT_JSON = "text/json";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CHARSET = "UTF-8";
    public static final String HEADER = "header";
    public static final String DATA = "data";
    public static final String RULE = "spay";
    public static final String STATUSCODE = "statusCode";
    public static final int STATUS_200 = 200;
    public static final int STATUS_302 = 302;
    public static int CONNECTTIMEOUT = 6000;
    public static int SOCKETTIMEOUT = 120000;

    public static Map<String, Object> get(ConfigContext apicontext, Map<String, String> reqMap) throws Exception {
        String plain = UMFHttpClient.getPlain(reqMap);
        String plainEncode = UMFHttpClient.getPlainEncode(reqMap);
        String url = apicontext.getUrl();
        String merId = apicontext.getMerId();
        String charset = apicontext.getCharset();
        if (charset == null || "".equals(charset)) {
            charset = CHARSET;
        }
        String sign = RSAUtil.createSign(plain, merId, RULE, charset);
        log.info(String.format("\u7b7e\u540d\uff1a%s", sign));
        return UMFHttpClient.get(String.valueOf(url) + "?" + plainEncode, sign, charset);
    }

    public static Map<String, Object> post(ConfigContext apicontext, Object obj) throws Exception {
        String url = apicontext.getUrl();
        String merId = apicontext.getMerId();
        String rsaCharset = apicontext.getCharset();
        if (rsaCharset == null || "".equals(rsaCharset)) {
            rsaCharset = CHARSET;
        }
        Gson gson = new Gson();
        String body = gson.toJson(obj);
        String sign = RSAUtil.createSign(body, merId, RULE, rsaCharset);
        return UMFHttpClient.post(url, body, sign, rsaCharset);
    }

    public static Map<String, Object> get(String url, String charset, Map<String, String> reqMap) throws Exception {
        String plain = UMFHttpClient.getPlainEncode(reqMap);
        if (charset == null || "".equals(charset)) {
            charset = CHARSET;
        }
        return UMFHttpClient.get(String.valueOf(url) + "?" + plain, null, charset);
    }

    public static <T> Map<String, Object> post(String url, T t, String charset) throws Exception {
        Gson gson = new Gson();
        String body = gson.toJson(t);
        return UMFHttpClient.post(url, body, null, charset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> post(String url, String json, String sign, String charset) throws Exception {
        if (StringUtils.isEmpty(url)) {
            throw new RuntimeException("HttpClient,error url:" + url);
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(CONNECTTIMEOUT).setSocketTimeout(SOCKETTIMEOUT).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        if (StringUtils.isEmpty(charset)) {
            charset = CHARSET;
        }
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader(CONTENT_TYPE, CONTENT_TYPE_JSON);
        if (sign != null && !"".equals(sign.trim())) {
            httpPost.setHeader("Signature", sign);
        }
        StringEntity se = new StringEntity(json, charset);
        CloseableHttpResponse response = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            try {
                se.setContentType(CONTENT_TYPE_TEXT_JSON);
                se.setContentEncoding((Header)new BasicHeader(CONTENT_TYPE, CONTENT_TYPE_JSON));
                httpPost.setEntity((HttpEntity)se);
                response = httpClient.execute((HttpUriRequest)httpPost);
                int statusCode = response.getStatusLine().getStatusCode();
                String result = null;
                if (statusCode != 200) {
                    if (statusCode != 302) {
                        httpPost.abort();
                        throw new RuntimeException("HttpClient,error status code :" + statusCode);
                    }
                    result = response.getHeaders("location")[0].getValue();
                } else {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        result = EntityUtils.toString((HttpEntity)entity, (String)charset);
                    }
                    Header[] headers = response.getAllHeaders();
                    EntityUtils.consume((HttpEntity)entity);
                    map.put(HEADER, headers);
                }
                map.put(STATUSCODE, statusCode);
                map.put(DATA, result);
                return map;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (response == null) return map;
                response.close();
                return map;
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> get(String url, String sign, String charset) throws Exception {
        if (StringUtils.isEmpty(url)) {
            throw new RuntimeException("HttpClient,error url:" + url);
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(CONNECTTIMEOUT).setSocketTimeout(SOCKETTIMEOUT).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        if (StringUtils.isEmpty(charset)) {
            charset = CHARSET;
        }
        HttpGet httpget = new HttpGet(url);
        if (sign != null && !"".equals(sign.trim())) {
            httpget.setHeader("Signature", sign);
        }
        CloseableHttpResponse response = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            try {
                response = httpClient.execute((HttpUriRequest)httpget);
                String result = null;
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    if (statusCode != 302) {
                        httpget.abort();
                        throw new RuntimeException("HttpClient,error status code :" + statusCode);
                    }
                    result = response.getHeaders("location")[0].getValue();
                } else {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        result = EntityUtils.toString((HttpEntity)entity, (String)charset);
                    }
                    Header[] headers = response.getAllHeaders();
                    EntityUtils.consume((HttpEntity)entity);
                    map.put(HEADER, headers);
                }
                map.put(STATUSCODE, statusCode);
                map.put(DATA, result);
                return map;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (response == null) return map;
                response.close();
                return map;
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public static String getPlain(Map<String, String> reqMap) {
        Object[] obj = reqMap.keySet().toArray();
        String value = "";
        StringBuilder reqstr = new StringBuilder("");
        Arrays.sort(obj);
        Object[] objectArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            String s = object.toString();
            if (!s.equalsIgnoreCase("Signature") && !"Signature".equals(s) && StringUtils.isNotEmpty(value = StringUtils.trim(reqMap.get(s)))) {
                reqstr.append(s).append("=").append(value).append("&");
            }
            ++n2;
        }
        String plain = reqstr.substring(0, reqstr.length() - 1);
        return plain;
    }

    public static String getPlainEncode(Map<String, String> reqMap) {
        Object[] obj = reqMap.keySet().toArray();
        String value = "";
        StringBuilder reqstr = new StringBuilder("");
        Arrays.sort(obj);
        Object[] objectArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            String s = object.toString();
            if (!s.equalsIgnoreCase("Signature") && !"Signature".equals(s) && StringUtils.isNotEmpty(value = reqMap.get(s))) {
                try {
                    value = URLEncoder.encode(value.replaceAll("\\+", "%2B"), CHARSET);
                }
                catch (Exception e) {
                    RuntimeException rex = new RuntimeException();
                    rex.setStackTrace(e.getStackTrace());
                    throw rex;
                }
                reqstr.append(s).append("=").append(value).append("&");
            }
            ++n2;
        }
        String plain = reqstr.substring(0, reqstr.length() - 1);
        return plain;
    }
}

