/*
 * Decompiled with CFR 0.152.
 */
package com.umpay.util;

import com.umpay.factory.RSACertFactory;
import com.umpay.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class RSAUtil {
    private static final String DEFAULT_CHARSET = "UTF-8";

    public static byte[] sign(PrivateKey pk, byte[] data, String signProject) {
        byte[] sb = null;
        try {
            String sha = null;
            if ("rest".equals(signProject)) {
                sha = "SHA256withRSA";
            } else if ("spay".equals(signProject)) {
                sha = "SHA1withRSA";
            }
            Signature signature = Signature.getInstance(sha);
            signature.initSign(pk);
            signature.update(data);
            sb = signature.sign();
        }
        catch (Exception arg3) {
            return null;
        }
        return sb;
    }

    public static X509Certificate genCertificate(byte[] certData) {
        ByteArrayInputStream bais = new ByteArrayInputStream(certData);
        try {
            CertificateFactory e = CertificateFactory.getInstance("X.509");
            return (X509Certificate)e.generateCertificate(bais);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean verifySign(X509Certificate cert, byte[] plain, byte[] signData) {
        try {
            Signature e = Signature.getInstance("SHA256withRSA");
            e.initVerify(cert);
            e.update(plain);
            return e.verify(signData);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String createSign(String plain, String merId, String signRule, String charset) {
        String sign = null;
        InputStream in = null;
        if (charset == null || "".equals(charset)) {
            charset = DEFAULT_CHARSET;
        }
        try {
            try {
                PrivateKey pk = RSACertFactory.getPk(merId);
                byte[] signData = RSAUtil.sign(pk, plain.getBytes(charset), signRule);
                sign = new String(Base64.encode(signData));
            }
            catch (Exception localException) {
                localException.printStackTrace();
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException localIOException1) {
                    localIOException1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException localIOException1) {
                localIOException1.printStackTrace();
            }
        }
        return sign;
    }

    public static boolean verifySign(String plain, String sign, String charset) throws Exception {
        if (charset == null || "".equals(charset)) {
            charset = DEFAULT_CHARSET;
        }
        X509Certificate cert = RSACertFactory.getUmfCert();
        byte[] signData = Base64.decode(sign.getBytes(charset));
        return RSAUtil.verify(cert, plain.getBytes(charset), signData);
    }

    private static boolean verify(X509Certificate cert, byte[] plain, byte[] signData) {
        try {
            Signature sig = Signature.getInstance("SHA1withRSA");
            sig.initVerify(cert);
            sig.update(plain);
            return sig.verify(signData);
        }
        catch (Exception e) {
            return false;
        }
    }
}

