/*
 * Decompiled with CFR 0.152.
 */
package com.waiqin365.openapi.util;

import com.waiqin365.openapi.util.WQPostMethod;
import com.waiqin365.openapi.vo.WQRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpUtil {
    public static Log log = LogFactory.getLog(HttpUtil.class);

    public static String httpPost(WQRequest request) throws Exception {
        return HttpUtil.httpPost(request.getRequestUrl(), request.getRequestdata(), request.getWqOpenApi().getTimeout());
    }

    public static String httpPost(String url, String body, int timeout) throws Exception {
        log.info((Object)("REQ WQ365 URL: " + url));
        log.info((Object)("REQ WQ365 BODY: " + body));
        HttpClient http = new HttpClient();
        http.getHttpConnectionManager().getParams().setConnectionTimeout(timeout);
        http.getHttpConnectionManager().getParams().setSoTimeout(timeout);
        WQPostMethod method = new WQPostMethod(url.toString());
        method.setRequestEntityBody(body.toString());
        http.executeMethod((HttpMethod)method);
        return HttpUtil.getStreamBody(method);
    }

    private static String getStreamBody(WQPostMethod method) throws Exception {
        InputStream in = null;
        try {
            String encode;
            boolean isGzip = false;
            Header encodeHeader = method.getResponseHeader("Content-Encoding");
            if (encodeHeader != null && (encode = encodeHeader.getValue()).contains("gzip")) {
                isGzip = true;
                log.info((Object)"RESPONSE is Gzip!");
            }
            in = method.getResponseBodyAsStream();
            byte[] body = HttpUtil.getStreamBody(in);
            byte[] unGzipBody = HttpUtil.unGzip(body, isGzip);
            String ret = null;
            ret = unGzipBody != null ? new String(unGzipBody, method.getResponseCharSet()) : "";
            log.info((Object)("RES WQ365: " + ret));
            String string = ret;
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.error((Object)"\u5173\u95ed\u8f93\u5165\u6d41\u65f6\u53d1\u751f\u5f02\u5e38,\u5806\u6808\u4fe1\u606f\u5982\u4e0b", (Throwable)e);
                    throw e;
                }
            }
        }
    }

    public static byte[] unGzip(byte[] data, boolean isGzip) {
        byte[] b = null;
        try {
            ByteArrayOutputStream baos;
            GZIPInputStream gzip;
            ByteArrayInputStream bis;
            if (data == null || data.length < 1) {
                return b;
            }
            if (isGzip) {
                bis = new ByteArrayInputStream(data);
                gzip = new GZIPInputStream(bis);
                byte[] buf = new byte[1024];
                int num = -1;
                baos = new ByteArrayOutputStream();
                while ((num = gzip.read(buf, 0, buf.length)) != -1) {
                    baos.write(buf, 0, num);
                }
            } else {
                return data;
            }
            b = baos.toByteArray();
            baos.flush();
            baos.close();
            gzip.close();
            bis.close();
        }
        catch (Exception ex) {
            log.error((Object)"ungzip fail", (Throwable)ex);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getStreamBody(InputStream is) {
        byte[] body = null;
        ByteArrayOutputStream out = null;
        try {
            int c;
            if (is == null) {
                byte[] byArray = null;
                return byArray;
            }
            out = new ByteArrayOutputStream();
            byte[] by = new byte[1024];
            while ((c = is.read(by)) != -1) {
                out.write(by, 0, c);
            }
            body = out.toByteArray();
            if (out != null) {
                out.flush();
            }
        }
        catch (Exception e) {
            log.warn((Object)"\u83b7\u53d6\u8bf7\u6c42\u4e3b\u4f53\u4fe1\u606f\u51fa\u9519\uff0c\u539f\u56e0:", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"\u5173\u95ed\u8f93\u5165\u8f93\u51fa\u5b57\u8282\u6d41\u51fa\u9519\uff0c\u539f\u56e0:", (Throwable)e);
            }
        }
        return body;
    }
}

