/*
 * Decompiled with CFR 0.152.
 */
package com.waiqin365.openapi.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class WQPostMethod
extends PostMethod {
    public WQPostMethod(String url) {
        super(url);
    }

    public String getRequestCharSet() {
        return "UTF-8";
    }

    public String getResponseCharSet() {
        return "UTF-8";
    }

    public void setRequestEntityBody(String body) throws UnsupportedEncodingException {
        this.addRequestHeader("Accept-Encoding", "gzip, deflate");
        this.setRequestEntity((RequestEntity)new StringRequestEntity(body, "application/json", this.getRequestCharSet()));
    }

    public String getResponseBodyAsString() throws IOException {
        if (this.getResponseBody() != null || this.getResponseStream() != null) {
            String str;
            Header header = this.getResponseHeader("Content-Encoding");
            if (header != null && header.getValue().toLowerCase().indexOf("gzip") > -1) {
                String str2;
                InputStream is = this.getResponseBodyAsStream();
                GZIPInputStream gzip = new GZIPInputStream(is);
                InputStreamReader isr = new InputStreamReader((InputStream)gzip, this.getResponseCharSet());
                BufferedReader br = new BufferedReader(isr);
                StringBuffer sb = new StringBuffer();
                while ((str2 = br.readLine()) != null) {
                    sb.append(str2);
                }
                isr.close();
                gzip.close();
                return sb.toString();
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getResponseBodyAsStream(), this.getResponseCharSet()));
            StringBuffer sb = new StringBuffer();
            while ((str = reader.readLine()) != null) {
                sb.append(str);
            }
            return sb.toString();
        }
        return null;
    }
}

