/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.cloud.open.sdk.api;

import com.alibaba.fastjson.annotation.JSONField;
import com.youzan.cloud.open.sdk.api.ApiParams;
import com.youzan.cloud.open.sdk.common.constant.OAuthEnum;
import com.youzan.cloud.open.sdk.common.exception.SDKException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AbstractApiParams
implements ApiParams {
    @Override
    public Map<String, Object> toParams() throws SDKException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            Field[] fields;
            Class<?> clazz = this.getClass();
            for (Field field : fields = clazz.getDeclaredFields()) {
                String fieldName = field.getName();
                if (fieldName.equals("serialVersionUID")) continue;
                JSONField annotation = field.getAnnotation(JSONField.class);
                Method method = clazz.getMethod("get".concat(this.capitalizeName(fieldName)), new Class[0]);
                String realName = annotation.name();
                if (StringUtils.isNotBlank((CharSequence)realName)) {
                    params.put(realName, method.invoke((Object)this, new Object[0]));
                    continue;
                }
                params.put(fieldName, method.invoke((Object)this, new Object[0]));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new SDKException((Exception)e, OAuthEnum.ErrorMessage.TOPARAM_ERROR);
        }
        return params;
    }

    private String capitalizeName(String name) {
        char[] ch = name.toCharArray();
        if (ch[0] >= 'a' && ch[0] <= 'z') {
            ch[0] = (char)(ch[0] - 32);
        }
        return new String(ch);
    }
}

