/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.cloud.open.sdk.core;

import java.net.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class HttpConfig {
    private String tokenHost;
    private Long connectTimeout;
    private Map<String, String> commonHeaders;
    private Set<Interceptor> interceptors;
    private Proxy proxy;
    private OkHttpClient.Builder builder;

    private HttpConfig() {
    }

    private HttpConfig(String tokenHost, Long connectTimeout, Map<String, String> commonHeaders, Set<Interceptor> interceptors, Proxy proxy, OkHttpClient.Builder builder) {
        this.tokenHost = tokenHost;
        this.connectTimeout = connectTimeout;
        this.commonHeaders = commonHeaders;
        this.interceptors = interceptors;
        this.proxy = proxy;
        this.builder = builder;
    }

    public static HttpConfigBuilder builder() {
        return new HttpConfigBuilder();
    }

    public String getTokenHost() {
        return this.tokenHost;
    }

    public Map<String, String> getCommonHeaders() {
        return this.commonHeaders;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public Long getConnectTimeout() {
        return this.connectTimeout;
    }

    public OkHttpClient.Builder getBuilder() {
        return this.builder;
    }

    public Set<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public static class HttpConfigBuilder {
        private String tokenHost = "https://open.youzanyun.com";
        private Map<String, String> commonHeaders = new HashMap<String, String>();
        private Long connectTimeout = 5L;
        private Set<Interceptor> interceptors = new HashSet<Interceptor>();
        private Proxy proxy;
        private OkHttpClient.Builder builder;

        public HttpConfigBuilder tokenHost(String tokenHost) {
            this.tokenHost = tokenHost;
            return this;
        }

        public HttpConfigBuilder commonHeaders(Map<String, String> commonHeaders) {
            this.commonHeaders = commonHeaders;
            return this;
        }

        public HttpConfigBuilder connectTimeout(Long connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public HttpConfigBuilder addInterceptor(Interceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }

        public HttpConfigBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public HttpConfigBuilder OkHttpClientBuilder(OkHttpClient.Builder builder) {
            this.builder = builder;
            return this;
        }

        public HttpConfig build() {
            this.commonHeaders.put("UserAgent", "YZY-Open-Client 1.0.5-Java");
            return new HttpConfig(this.tokenHost, this.connectTimeout, this.commonHeaders, this.interceptors, this.proxy, this.builder);
        }
    }
}

