/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.cloud.open.sdk.core.client.auth;

import com.youzan.cloud.open.sdk.common.constant.OAuthEnum;
import com.youzan.cloud.open.sdk.common.exception.SDKException;
import com.youzan.cloud.open.sdk.common.util.CheckUtils;
import com.youzan.cloud.open.sdk.core.client.auth.Auth;
import org.apache.commons.lang3.StringUtils;

public class Sign
implements Auth {
    private OAuthEnum.Signature signatureType;
    private String identify;
    private String clientPrivateKey;
    private String youzanPublicKey;
    private String publicKeyId;

    private Sign() {
    }

    private Sign(String identify, String clientPrivateKey, String youzanPublicKey, String publicKeyId, OAuthEnum.Signature signature) {
        this.identify = identify;
        this.clientPrivateKey = clientPrivateKey;
        this.youzanPublicKey = youzanPublicKey;
        this.publicKeyId = publicKeyId;
        this.signatureType = signature;
    }

    public static RSA2Builder RSA2Builder() {
        return new RSA2Builder();
    }

    @Override
    public OAuthEnum.OAuthType getType() {
        return OAuthEnum.OAuthType.SIGN;
    }

    public OAuthEnum.Signature getSignatureType() {
        return this.signatureType;
    }

    public String getIdentify() {
        return this.identify;
    }

    public String getClientPrivateKey() {
        return this.clientPrivateKey;
    }

    public String getYouzanPublicKey() {
        return this.youzanPublicKey;
    }

    public String getPublicKeyId() {
        return this.publicKeyId;
    }

    public String toString() {
        return "Sign{signatureType=" + this.signatureType + ", identify='" + this.identify + '\'' + ", clientPrivateKey='" + this.clientPrivateKey + '\'' + ", youzanPublicKey='" + this.youzanPublicKey + '\'' + ", publicKeyId='" + this.publicKeyId + '\'' + '}';
    }

    public static class RSA2Builder {
        private static String youzanPublicKey = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3KaKbggtc8h+Pe8eXXXIvW47dxYP+TosR+PIOO3vo9hJVSuMAYBYN7zYP6rvEZmk4NDfxYEETVB/c2d4uCcDoYuvpxNGY43Mlw+wbCErAdiFxXG/d3C3zuupPZ6SSrKKhjRVoFIWD/14TW/Rhh2UNucpI67KEogBXQ3N+efpQ6NCAZbpv2WnfRphLyYnqCCzJqaZlp/O27DRxkakPqLtWdRppdfp/zB645eCO8q1gCLbdCl4XCHYK+k1DlQtMMenpIkK4B5rqmNbCjEMjAOHNXbOsOS+nT9emEbEF6v6SwNxyv0HrR/iT4aUEuuImN7Xh7+VayVI00daap+5uX5FEQIDAQAB";
        private String identify;
        private String clientPrivateKey;
        private String publicKeyId;

        public RSA2Builder identify(String identify) {
            this.identify = identify;
            return this;
        }

        public RSA2Builder publicKeyId(String publicKeyId) {
            this.publicKeyId = publicKeyId;
            return this;
        }

        public RSA2Builder clientPrivateKey(String clientPrivateKey) {
            this.clientPrivateKey = clientPrivateKey;
            return this;
        }

        public RSA2Builder youzanPublicKey(String youzanPublicKey) {
            RSA2Builder.youzanPublicKey = youzanPublicKey;
            return this;
        }

        public Sign build() throws SDKException {
            CheckUtils.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.identify), (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"identify can not be null!");
            CheckUtils.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.publicKeyId), (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"publicKeyId can not be null!");
            CheckUtils.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientPrivateKey), (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"clientPrivateKey can not be null!");
            return new Sign(this.identify, this.clientPrivateKey, youzanPublicKey, this.publicKeyId, OAuthEnum.Signature.RSA2);
        }
    }
}

