/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.cloud.open.sdk.core.client.executor;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.youzan.cloud.open.sdk.api.API;
import com.youzan.cloud.open.sdk.common.constant.OAuthEnum;
import com.youzan.cloud.open.sdk.common.exception.SDKException;
import com.youzan.cloud.open.sdk.common.response.GatewayErrorResponse;
import com.youzan.cloud.open.sdk.common.util.CheckUtils;
import com.youzan.cloud.open.sdk.core.HttpConfig;
import com.youzan.cloud.open.sdk.core.client.auth.Auth;
import com.youzan.cloud.open.sdk.core.client.executor.Executor;
import com.youzan.cloud.open.sdk.core.client.http.HttpClient;
import com.youzan.cloud.open.sdk.core.client.http.RequestParameter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractExecutor
implements Executor {
    private HttpClient httpClient;

    @Override
    public String execute(HttpClient httpClient, API api, Auth auth) throws SDKException {
        this.httpClient = httpClient;
        RequestParameter requestParameter = this.beforeExecute(api, auth);
        Response response = this.executionMethod(api.getHttpMethod(), requestParameter);
        return this.afterExecute(response, api, auth);
    }

    private Response executionMethod(String httpMethod, RequestParameter requestParameter) throws SDKException {
        if (!"POST".equals(httpMethod)) {
            throw new SDKException(null, OAuthEnum.ErrorMessage.SDK_ERROR, "Call method is incorrect\uff1a" + httpMethod);
        }
        Request request = this.buildPostRequest(requestParameter);
        return this.httpClient.send(request);
    }

    private RequestParameter beforeExecute(API api, Auth auth) throws SDKException {
        String url = this.buildBaseUrl(api);
        HashMap<String, String> certificate = this.buildCertificate(api, auth);
        Headers headers = this.buildHeaders(api);
        return new RequestParameter(url, certificate, headers, api.getAPIParams().toParams(), api.hasFile());
    }

    protected String afterExecute(Response response, API api, Auth auth) throws SDKException {
        CheckUtils.checkArgument((boolean)response.isSuccessful(), (Integer)response.code(), (String)response.message());
        try {
            ResponseBody body = response.body();
            if (body == null) {
                return null;
            }
            String bodyStr = body.string();
            if (StringUtils.isNotBlank((CharSequence)bodyStr)) {
                if (bodyStr.contains("gw_err_resp")) {
                    GatewayErrorResponse gatewayErrorResponse = (GatewayErrorResponse)JSON.parseObject((String)bodyStr, GatewayErrorResponse.class);
                    GatewayErrorResponse.ErrorResponse gwErrResp = gatewayErrorResponse.getGwErrResp();
                    throw new SDKException(gwErrResp.getErrCode(), gwErrResp.getErrMsg());
                }
                return bodyStr;
            }
            return null;
        }
        catch (IOException e) {
            throw new SDKException((Exception)e, OAuthEnum.ErrorMessage.IO_ERROR, e.getMessage());
        }
    }

    protected String buildBaseUrl(API api) {
        String gateway = api.getGateway();
        String url = api.hasContainRichText() ? String.format("%s/api/_textarea_/%s/%s", gateway, api.getName(), api.getVersion()) : String.format("%s/api/%s/%s", gateway, api.getName(), api.getVersion());
        return url;
    }

    protected abstract HashMap<String, String> buildCertificate(API var1, Auth var2) throws SDKException;

    private Headers buildHeaders(API api) {
        HashMap<String, String> headers = new HashMap<String, String>();
        HttpConfig httpConfig = this.httpClient.getHttpConfig();
        if (httpConfig != null) {
            headers.putAll(this.httpClient.getHttpConfig().getCommonHeaders());
        }
        headers.putAll(api.getHeaders());
        return Headers.of(headers);
    }

    private Request buildPostRequest(RequestParameter requestParameter) {
        RequestBody requestBody;
        String url = this.buildPostUpUrl(requestParameter);
        if (requestParameter.isHasFile()) {
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            Map<String, Object> objectMap = requestParameter.getData();
            for (Map.Entry<String, Object> entry : objectMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof File) {
                    File file = (File)value;
                    byte[] bytes = new byte[]{};
                    try {
                        bytes = Files.readAllBytes(file.toPath());
                    }
                    catch (IOException e) {
                        System.err.println("file upload IOException");
                    }
                    builder.addFormDataPart(key, file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])bytes));
                    continue;
                }
                builder.addFormDataPart(key, value.toString());
            }
            requestBody = builder.build();
        } else {
            String postBody = JSON.toJSONString(requestParameter.getData());
            requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json;charset=UTF-8"), (String)postBody);
        }
        return new Request.Builder().url(url).headers(requestParameter.getHeaders()).post(requestBody).build();
    }

    private String buildPostUpUrl(RequestParameter requestParameter) {
        String dataStr = Joiner.on((String)"&").withKeyValueSeparator("=").join(requestParameter.getCertificate());
        if (StringUtils.isEmpty((CharSequence)dataStr)) {
            return requestParameter.getUrl();
        }
        return requestParameter.getUrl() + "?" + dataStr;
    }
}

