/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.cloud.open.sdk.core.client.executor.handler;

import com.alibaba.fastjson.JSONObject;
import com.youzan.cloud.open.sdk.api.API;
import com.youzan.cloud.open.sdk.common.constant.OAuthEnum;
import com.youzan.cloud.open.sdk.common.exception.SDKException;
import com.youzan.cloud.open.sdk.common.util.CheckUtils;
import com.youzan.cloud.open.sdk.core.client.auth.Auth;
import com.youzan.cloud.open.sdk.core.client.auth.Sign;
import com.youzan.cloud.open.sdk.core.client.executor.AbstractExecutor;
import com.youzan.cloud.open.sdk.core.oauth.signature.SignatureHandler;
import com.youzan.cloud.open.sdk.core.oauth.signature.SignatureHandlerFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class SignExecutor
extends AbstractExecutor {
    @Override
    protected HashMap<String, String> buildCertificate(API api, Auth auth) throws SDKException {
        try {
            Sign sign = (Sign)auth;
            SignatureHandler signatureHandler = SignatureHandlerFactory.getSignatureHandler(sign.getSignatureType());
            Map requestMap = api.getAPIParams().toParams();
            String signStr = signatureHandler.sign(sign.getClientPrivateKey(), requestMap);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(StringUtils.lowerCase((String)OAuthEnum.OAuthType.SIGN.name()), URLEncoder.encode(signStr, "utf-8"));
            map.put("identity", sign.getIdentify());
            map.put("sign_type", sign.getSignatureType().name());
            map.put("public_key_id", sign.getPublicKeyId());
            return map;
        }
        catch (UnsupportedEncodingException e) {
            throw new SDKException((Exception)e, OAuthEnum.ErrorMessage.BUILD_CERTIFICATE_ERROR, e.getMessage());
        }
    }

    @Override
    protected String afterExecute(Response response, API api, Auth auth) throws SDKException {
        String executeStr = super.afterExecute(response, api, auth);
        if (executeStr == null) {
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)executeStr);
        String signStr = (String)jsonObject.get((Object)"sign");
        String signType = (String)jsonObject.get((Object)"sign_type");
        jsonObject.remove((Object)"sign");
        jsonObject.remove((Object)"sign_type");
        CheckUtils.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)signStr), (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"\u6821\u9a8c sign \u4e3a\u7a7a");
        CheckUtils.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)signType), (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"\u6821\u9a8c signType \u4e3a\u7a7a");
        Sign sign = (Sign)auth;
        OAuthEnum.Signature signature = OAuthEnum.Signature.valueOf((String)signType);
        SignatureHandler signatureHandler = SignatureHandlerFactory.getSignatureHandler(signature);
        Map innerMap = jsonObject.getInnerMap();
        Boolean check = signatureHandler.check(sign.getYouzanPublicKey(), innerMap, signStr);
        if (check.booleanValue()) {
            return jsonObject.toJSONString();
        }
        throw new SDKException(null, OAuthEnum.ErrorMessage.SDK_ERROR, "sign check response body error");
    }
}

