/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.cloud.open.sdk.core.oauth.token;

import com.youzan.cloud.open.sdk.common.constant.OAuthEnum;
import com.youzan.cloud.open.sdk.common.exception.SDKException;
import com.youzan.cloud.open.sdk.core.oauth.token.TokenHandler;
import com.youzan.cloud.open.sdk.core.oauth.token.handler.CertificateTokenHandler;
import com.youzan.cloud.open.sdk.core.oauth.token.handler.CodeTokenHandler;
import com.youzan.cloud.open.sdk.core.oauth.token.handler.RefreshTokenHandler;
import com.youzan.cloud.open.sdk.core.oauth.token.handler.SilentTokenHandler;
import java.util.concurrent.ConcurrentHashMap;

public class TokenHandlerFactory {
    private static ConcurrentHashMap<OAuthEnum.TokenType, Class> tokenHandlerMap = new ConcurrentHashMap();

    public static TokenHandler getTokenHandler(OAuthEnum.TokenType tokenType) throws SDKException {
        try {
            return (TokenHandler)tokenHandlerMap.get(tokenType).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SDKException((Exception)e, OAuthEnum.ErrorMessage.HANDLER_FACTORY_ERROR, e.getMessage());
        }
    }

    static {
        tokenHandlerMap.put(OAuthEnum.TokenType.silent, SilentTokenHandler.class);
        tokenHandlerMap.put(OAuthEnum.TokenType.certificate, CertificateTokenHandler.class);
        tokenHandlerMap.put(OAuthEnum.TokenType.authorization_code, CodeTokenHandler.class);
        tokenHandlerMap.put(OAuthEnum.TokenType.refresh_token, RefreshTokenHandler.class);
    }
}

