package com.qingstor.sdk.chinayanghe;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;

/**
 * Object PUT 上传请求类
 * @author 
 *
 */
public class QsPutObjectRequest implements Serializable{
	
	/** bucket名称(必须) */
	private String bucket;
	/** 文件名标示(必须) */
	private String key;
	/** put 文件 */
	private File file;
	/** put inputStream */
	private InputStream inputStream;
	/** httpContentTyp */
	private String httpContentType;

	/**
	 * 构造函数
	 * @param bucket bucket名称
	 * @param key  上传青云的Object标示，确保在同一bucket中标示唯一
	 * @param inputStream  待Put的Object流 
	 * @param file  待Put的文件
	 * @param httpContentType  对照HttpContentType信息
	 */
	public QsPutObjectRequest(String bucket, String key, InputStream inputStream, File file, String httpContentType) {
		this.bucket = bucket;
		this.key = key;
		this.file = file;
		this.inputStream = inputStream;
		this.httpContentType = httpContentType;
	}

	/**
	 * 构造函数
	 * @param bucket  bucket bucket名称
	 * @param key 上传青云的Object标示，确保在同一bucket中标示唯一
	 * @param input  待Put的Object流 
	 * @param httpContentType 对照HttpContentType信息
	 */
	public QsPutObjectRequest(String bucket, String key, InputStream input, String httpContentType) {
		this(bucket, key, input, null, httpContentType);
	}

	/**
	 * 构造函数
	 * @param bucket
	 * @param key 上传青云的Object标示，确保在同一bucket中标示唯一
	 * @param file  待Put的文件
	 * @param httpContentType 对照HttpContentType信息
	 */
	public QsPutObjectRequest(String bucket, String key, File file, String httpContentType) {
		this(bucket, key, null, file, httpContentType);
	}

	/**
	 * 获取上传文件
	 * 
	 * @return
	 */
	public File getFile() {
		return file;
	}

	/**
	 * 设置上传的文件
	 */
	public void setFile(File file) {
		this.file = file;
	}

	/**
	 * 获取上传的stream
	 * 
	 * @return
	 */
	public InputStream getInputStream() {
		return inputStream;
	}

	/**
	 * 设置上传的stream
	 */
	public void setInputStream(InputStream inputStream) {
		this.inputStream = inputStream;
	}

	/**
	 * 获取Bucket
	 * 
	 * @return
	 */
	public String getBucket() {
		return bucket;
	}

	/**
	 * 设置Bucket
	 */
	public void setBucket(String bucket) {
		this.bucket = bucket;
	}

	/**
	 * 获取文件的唯一标示
	 * 
	 * @return
	 */
	public String getKey() {
		return key;
	}

	/**
	 * 设置文件的唯一标示(即保存到青云上的文件名称，文件名称可以没有文件后缀，<br>
	 * 但请确保在文件名在一个Bucket中是唯一的)<br>
	 * 如果想把文件放到指定目录下，如:dir/file.txt<br>
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 获取ContentType
	 * 
	 * @return
	 */
	public String getHttpContentType() {
		if (httpContentType == null || "".equals(httpContentType.trim())) {
			return "text/xml";
		}
		return httpContentType;
	}

	/**
	 * 设置httpContentType (如果不设置,默认为 "text/xml" )<br>
	 * 常用文件和ContentType对照：<br>
	 * .txt&nbsp;&nbsp;->&nbsp;&nbsp;text/plain<br>
	 * .xls&nbsp;&nbsp;->&nbsp;&nbsp;application/x-xls<br>
	 * .doc&nbsp;&nbsp;->&nbsp;&nbsp;application/msword<br>
	 * .html&nbsp;&nbsp;->&nbsp;&nbsp;text/html<br>
	 * .ico&nbsp;&nbsp;->&nbsp;&nbsp;image/x-icon<br>
	 * .img&nbsp;&nbsp;->&nbsp;&nbsp;application/x-img<br>
	 * .jpe .jpeg .jpg&nbsp;&nbsp;->&nbsp;&nbsp;image/jpeg<br>
	 * .mp4&nbsp;&nbsp;->&nbsp;&nbsp;video/mpeg4<br>
	 * .pic&nbsp;&nbsp;->&nbsp;&nbsp;application/x-pic<br>
	 * .png&nbsp;&nbsp;->&nbsp;&nbsp;image/png<br>
	 * .ppt&nbsp;&nbsp;->&nbsp;&nbsp;application/x-ppt<br>
	 * 
	 * @param httpContentType<br>
	 */
	public void setHttpContentType(String httpContentType) {
		this.httpContentType = httpContentType;
	}


}
