package com.qingstor.sdk.chinayanghe;

import com.qingstor.sdk.config.EvnContext;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.service.Bucket;
import com.qingstor.sdk.service.Bucket.PutBucketACLInput;
import com.qingstor.sdk.service.QingStor;

/**
  青云Object处理类
 * @author gaopan
 *
 */
public class QssObjectUtils {


	
	/**
	 * 对象的PUT
	 * @param putObjectRequest PUT对象
	 *@return OutputModel  statueCode==201时表示成功
	 *对象PUT成功后，可以通过${resouceUri}/${bucket}/${key}
	 */
	 public static OutputModel putObject(QsPutObjectRequest putObjectRequest){
		 OutputModel ret=null;
		 try {
			if(putObjectRequest==null||putObjectRequest.getKey()==null||
					"".equals(putObjectRequest.getKey())){
				ret=new OutputModel();
				ret.setStatueCode(99999);
				ret.setMessage("PARAM INVALIDATE!");
				return ret;
			}
			EvnContext evnContext= new EvnContext();
			QingStor storService = new QingStor(evnContext,EvnContext.getZone());
	    	Bucket bucket = storService.getBucket(putObjectRequest.getBucket(), EvnContext.getZone());
    		Bucket.PutObjectInput input = new Bucket.PutObjectInput();
	    	if(putObjectRequest.getInputStream()!=null){
	    		input.setBodyInputStream(putObjectRequest.getInputStream());
	    		input.setContentType(putObjectRequest.getHttpContentType());
	    	}else if(putObjectRequest.getFile()!=null){
		    	input.setBodyInputFile(putObjectRequest.getFile());
		    	input.setContentType(putObjectRequest.getHttpContentType());
		    	input.setContentLength(putObjectRequest.getFile().length());
	    	}else{
	    		ret=new OutputModel();
				ret.setStatueCode(99999);
				ret.setMessage("PUT OBJECT IS EMPTY!");
				return ret;
	    	}
	    	ret = bucket.putObject(putObjectRequest.getKey(), input);
	    	
		} catch (Exception e) {
			e.printStackTrace();
			ret=new OutputModel();
			ret.setStatueCode(99999);
			ret.setMessage("PUT OBJECT ERROR!");
			return ret;
			
		}
		return ret;
		 
	 }
	 /**
	  * 获取资源的访问路径
	  * @param bucketName
	  * @param key
	  * @return
	  */
	 public static String getQssResourceUrL(String bucketName, String key) {
		 new EvnContext();
	     return String.format("%s/%s/%s", EvnContext.getResouceUri(), bucketName, key);
	    }
	 
	 /**
	  * 创建Bucket
	  * @param bucketName
	  * @param acl
	  * @return OutputModel  statueCode==201时表示成功
	 * @throws QSException 
	  */
	  public static OutputModel createBucket(String bucketName, PutBucketACLInput acl) throws QSException {
		    EvnContext evnContext= new EvnContext();
			QingStor storService = new QingStor(evnContext,EvnContext.getZone());
			Bucket bucket = storService.getBucket(bucketName, EvnContext.getZone());
			bucket.putACL(acl);
	    	return bucket.put();
	  }
	  /**
	   * 从Bucket中删除一个Object
	   * @param bucketName 
	   * @param objectName 对象名
	    * @return OutputModel  statueCode==201时表示成功
	   * @throws QSException
	   */
	  public static OutputModel deletObjectFromBucket(String bucketName, String objectName) throws QSException {
		  EvnContext evnContext= new EvnContext();
		  QingStor storService = new QingStor(evnContext,EvnContext.getZone());
		  Bucket bucket = storService.getBucket(bucketName, EvnContext.getZone());
		  return  bucket.deleteObject(objectName);
	  }

}
