// +-------------------------------------------------------------------------
// | Copyright (C) 2016 Yunify, Inc.
// +-------------------------------------------------------------------------
// | Licensed under the Apache License, Version 2.0 (the "License");
// | you may not use this work except in compliance with the License.
// | You may obtain a copy of the License in the LICENSE file, or at:
// |
// | http://www.apache.org/licenses/LICENSE-2.0
// |
// | Unless required by applicable law or agreed to in writing, software
// | distributed under the License is distributed on an "AS IS" BASIS,
// | WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// | See the License for the specific language governing permissions and
// | limitations under the License.
// +-------------------------------------------------------------------------

package com.qingstor.sdk.config;

import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

import com.qingstor.sdk.constants.QSConstant;
import com.qingstor.sdk.request.ParamValidate;
import com.qingstor.sdk.utils.QSStringUtil;

public class EvnContext implements ParamValidate {


    public static String qingcloudStorHost = "yanghe1.stor.chinayanghe.com";
    public static String default_protocal = "https";

    private static String accessKey;

    private static String accessSecret;
    
    private static String zone;
    
    /**资源的访问路径**/
    private static String resouceUri;

    private static String host;
    private static String port="80";
    private static String protocol = default_protocal;
    private static String uri;
    private static String log_level = QSConstant.LOGGER_ERROR;
    private static String additionalUserAgent;

    private boolean safeOkHttp = true;
    
    private static  Boolean reloadConfig=false;

    public boolean isSafeOkHttp() {
        return safeOkHttp;
    }
    
    
    
    private static void initConfig(){
    	    try {
				Locale locale1 = new Locale("zh", "CN"); 
				ResourceBundle resb1 = ResourceBundle.getBundle("qingstore",locale1); 
				if(resb1!=null){
					accessKey=resb1.getString("access_key_id");
					accessSecret=resb1.getString("secret_access_key");
					host=resb1.getString("host");
					port=resb1.getString("port");
					protocol=resb1.getString("protocol");
					log_level=resb1.getString("log_level");
					zone=resb1.getString("zone");
					additionalUserAgent=resb1.getString("additional_user_agent");
					resouceUri=resb1.getString("resouceUri");
				}
			} catch (Exception e) {
				System.err.println("[ERROR]:未找到完整的Qss配置文件！");
			}
			
    }
    

    
    /**
     * This method will be deleted in subsequent releases
     * 
     * @param safeOkHttp
     */
    @Deprecated
    public void setSafeOkHttp(boolean safeOkHttp) {
        this.safeOkHttp = safeOkHttp;
    }

    public String getAccessKey() {
        return accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getAccessSecret() {
        return accessSecret;
    }

    public void setAccessSecret(String accessSecret) {
        this.accessSecret = accessSecret;
    }

    public String getHost() {
        return host;
    }

    /**
     * @param host example: qingstor.com
     */
    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return port;
    }

    /**
     * @param port example: 8080
     */
    public void setPort(String port) {
        this.port = port;
    }

    public String getProtocol() {
        return protocol;
    }

    /**
     * @param protocol example: https or http
     */
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getUri() {
        return uri;
    }

    public String getRequestUrl() {
        String joinUrl = this.getProtocol() + "://" + this.getHost();
        if (this.getPort() != null) {
            joinUrl += ":" + this.getPort();
        }
        if (this.getUri() != null) {
            joinUrl += this.getUri();
        }
        return joinUrl;
    }

    /**
     * @param uri example: /iaas
     */
    public void setUri(String uri) {
        this.uri = uri;
    }

    public EvnContext() {
    	if(!reloadConfig){
    		initConfig();
    		reloadConfig=true;
    	}
    }

    public EvnContext(String accessKey, String accessSecret) {
        this.setAccessKey(accessKey);
        this.setAccessSecret(accessSecret);
        this.setHost(qingcloudStorHost);
        QSConstant.LOGGER_LEVEL = this.getLog_level();
    }


    private static String getYamlConfig(String key, Map config) {
        if (config.containsKey(key)) {
            return String.valueOf(config.get(key));
        }
        return null;
    }

    public String getLog_level() {
        return log_level;
    }

    public void setLog_level(String log_level) {
        if (!QSStringUtil.isEmpty(log_level)) {
            QSConstant.LOGGER_LEVEL = log_level;
        }
        this.log_level = log_level;
    }


    /**
     * @return the additionalUserAgent
     */
    public String getAdditionalUserAgent() {
        return additionalUserAgent;
    }

    /**
     * @param additionalUserAgent the additionalUserAgent to set
     */
    public void setAdditionalUserAgent(String additionalUserAgent) {
        this.additionalUserAgent = additionalUserAgent;
    }
    
    

    public static String getZone() {
		return zone;
	}



	public static void setZone(String zone) {
		EvnContext.zone = zone;
	}

	


	public static String getResouceUri() {
		return resouceUri;
	}



	public static void setResouceUri(String resouceUri) {
		EvnContext.resouceUri = resouceUri;
	}



	@Override
    public String validateParam() {
        if (QSStringUtil.isEmpty(getAccessKey())) {
            return QSStringUtil.getParameterRequired("AccessKey", "EvnContext");
        }

        if (QSStringUtil.isEmpty(getRequestUrl())) {
            return QSStringUtil.getParameterRequired("host", "EvnContext");
        }
        if (!QSStringUtil.isEmpty(getAdditionalUserAgent())) {
            for (int i = 0; i < getAdditionalUserAgent().length(); i++) {
                char temp = getAdditionalUserAgent().charAt(i);
                int value = (int) temp;
                // Allow space(32) to ~(126) in ASCII Table, exclude "(34).
                if (value < 32 || value > 126 || value == 32 || value == 34) {
                    return "additional User-Agent contains characters that not allowed :"
                            + getAdditionalUserAgent().substring(i, i + 1);
                }
            }
        }
        return null;
    }

}
