/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.request;

import com.qingstor.sdk.config.EvnContext;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.RequestInputModel;
import com.qingstor.sdk.request.QSOkHttpRequestClient;
import com.qingstor.sdk.utils.Base64;
import com.qingstor.sdk.utils.QSLoggerUtil;
import com.qingstor.sdk.utils.QSParamInvokeUtil;
import com.qingstor.sdk.utils.QSSignatureUtil;
import com.qingstor.sdk.utils.QSStringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Request;

public class QSBuilder {
    private static final String REQUEST_PREFIX = "/";
    private static Logger logger = QSLoggerUtil.setLoggerHanlder(QSBuilder.class.getName());
    private Map context;
    private RequestInputModel paramsModel;
    private String requestMethod = "GET";
    private Map paramsQuery;
    private Map paramsBody;
    private Map paramsHeaders;
    private String requestUrl;

    public QSBuilder(Map context, RequestInputModel params) throws QSException {
        this.context = context;
        this.paramsModel = params;
        this.initParams();
        this.initRequestUrl();
    }

    private void initParams() throws QSException {
        this.paramsQuery = QSParamInvokeUtil.getRequestParams(this.paramsModel, "query");
        this.paramsBody = QSParamInvokeUtil.getRequestParams(this.paramsModel, "body");
        this.paramsHeaders = QSParamInvokeUtil.getRequestParams(this.paramsModel, "header");
        this.paramsHeaders = this.headParamEncoding(this.paramsHeaders);
        if (this.context.get("User-Agent") != null) {
            this.paramsHeaders.put("User-Agent", this.context.get("User-Agent"));
        }
        if (this.checkExpiresParam()) {
            this.paramsHeaders.clear();
            this.paramsHeaders.put("Expires", this.context.get("expires"));
        }
        String requestApi = (String)this.context.get("APIName");
        this.initHeadContentMd5(requestApi, this.paramsBody, this.paramsHeaders);
        this.requestMethod = (String)this.context.get("RequestMethod");
    }

    private void doSignature() throws QSException {
        String authSign = this.getParamSignature();
        logger.log(Level.INFO, "== authSign ==\n" + authSign + "\n");
        this.paramsHeaders.put("Authorization", authSign);
    }

    private String getParamSignature() throws QSException {
        String authSign = "";
        EvnContext evnContext = (EvnContext)this.context.get("evnContext");
        try {
            if (this.checkExpiresParam()) {
                authSign = QSSignatureUtil.generateSignature(evnContext.getAccessSecret(), this.getStringToSignature());
                authSign = URLEncoder.encode(authSign, "UTF-8");
            } else {
                authSign = QSSignatureUtil.generateAuthorization(evnContext.getAccessKey(), evnContext.getAccessSecret(), this.getStringToSignature());
            }
        }
        catch (Exception e) {
            throw new QSException("Auth signature error", e);
        }
        return authSign;
    }

    private void initRequestUrl() throws QSException {
        EvnContext evnContext = (EvnContext)this.context.get("evnContext");
        String bucketName = (String)this.context.get("bucketNameInput");
        String zone = (String)this.context.get("RequestZone");
        String objectName = (String)this.context.get("objectNameInput");
        String requestSuffixPath = this.getRequestSuffixPath((String)this.context.get("RequestURI"), bucketName, objectName);
        this.requestUrl = this.getSignedUrl(evnContext.getRequestUrl(), zone, bucketName, this.paramsQuery, requestSuffixPath);
        logger.log(Level.INFO, "== requestUrl ==\n" + this.requestUrl + "\n");
    }

    private Map headParamEncoding(Map headParams) throws QSException {
        HashMap head = new HashMap();
        for (Map.Entry entry : headParams.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("x-qs-") && !key.startsWith("X-QS-")) {
                head.put(key, headParams.get(key));
                continue;
            }
            String keyValue = QSStringUtil.asciiCharactersEncoding("" + headParams.get(key));
            head.put(key, keyValue);
        }
        return head;
    }

    private void initHeadContentMd5(String requestApi, Map paramsBody, Map paramsHead) throws QSException {
        if ("DeleteMultipleObjects".equals(requestApi) && paramsBody.size() > 0) {
            Object bodyContent = QSOkHttpRequestClient.getInstance().getBodyContent(paramsBody);
            MessageDigest instance = null;
            try {
                instance = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new QSException("MessageDigest MD5 error", e);
            }
            String contentMD5 = new String(Base64.encode(instance.digest(bodyContent.toString().getBytes())));
            paramsHead.put("Content-MD5", contentMD5);
        }
    }

    private String getRequestSuffixPath(String requestPath, String bucketName, String objectName) throws QSException {
        if (QSStringUtil.isEmpty(bucketName)) {
            return REQUEST_PREFIX;
        }
        String suffixPath = requestPath.replace("/<bucket-name>", "").replace("/<object-key>", "");
        objectName = QSStringUtil.isEmpty(objectName) ? "" : QSStringUtil.asciiCharactersEncoding(objectName);
        return String.format("%s%s%s", REQUEST_PREFIX, objectName, suffixPath);
    }

    private String getSignedUrl(String serviceUrl, String zone, String bucketName, Map paramsQuery, String requestSuffixPath) throws QSException {
        if ("".equals(bucketName) || bucketName == null) {
            return QSSignatureUtil.generateQSURL(paramsQuery, String.valueOf(serviceUrl) + requestSuffixPath);
        }
        String storRequestUrl = serviceUrl.replace("://", "://%s." + zone + ".");
        return QSSignatureUtil.generateQSURL(paramsQuery, String.valueOf(String.format(storRequestUrl, bucketName)) + requestSuffixPath);
    }

    public void setHeader(String key, String authorization) {
        this.paramsHeaders.put(key, authorization);
    }

    public void setSignature(String accessKey, String signature) throws QSException {
        try {
            EvnContext evnContext = (EvnContext)this.context.get("evnContext");
            evnContext.setAccessKey(accessKey);
            signature = this.checkExpiresParam() ? URLEncoder.encode(signature, "UTF-8") : String.format("QS %s:%s", accessKey, signature);
            this.paramsHeaders.put("Authorization", signature);
        }
        catch (UnsupportedEncodingException e) {
            throw new QSException("Auth signature error", e);
        }
    }

    public String getStringToSignature() throws QSException {
        String bucketName = (String)this.context.get("bucketNameInput");
        String requestPath = (String)this.context.get("RequestURI");
        String objectName = (String)this.context.get("objectNameInput");
        if (this.context.containsKey("objectNameInput")) {
            requestPath = requestPath.replace("<bucket-name>", bucketName);
            requestPath = requestPath.replace("<object-key>", QSStringUtil.asciiCharactersEncoding(objectName));
        } else {
            requestPath = requestPath.replace("<bucket-name>", String.valueOf(bucketName) + REQUEST_PREFIX);
        }
        return QSSignatureUtil.getStringToSignature(this.requestMethod, requestPath, this.paramsQuery, this.paramsHeaders);
    }

    public Request getRequest() throws QSException {
        if (this.checkExpiresParam()) {
            throw new QSException("You need to 'getExpiresRequestUrl' do request!");
        }
        this.getSignature();
        String requestApi = (String)this.context.get("APIName");
        if ("UploadMultipart".equals(requestApi)) {
            Request request = QSOkHttpRequestClient.getInstance().buildStorMultiUpload(this.requestMethod, this.paramsBody, this.requestUrl, this.paramsHeaders, this.paramsQuery);
            return request;
        }
        Request request = QSOkHttpRequestClient.getInstance().buildStorRequest(this.requestMethod, this.paramsBody, this.requestUrl, this.paramsHeaders);
        return request;
    }

    private boolean checkExpiresParam() {
        Object expiresTime = this.context.get("expires");
        return expiresTime != null;
    }

    public String getExpiresRequestUrl() throws QSException {
        Object expiresTime = this.context.get("expires");
        if (expiresTime != null) {
            EvnContext evnContext = (EvnContext)this.context.get("evnContext");
            String expireAuth = this.getSignature();
            String serviceUrl = evnContext.getRequestUrl();
            String objectName = (String)this.context.get("objectNameInput");
            String bucketName = (String)this.context.get("bucketNameInput");
            String zone = (String)this.context.get("RequestZone");
            String storRequestUrl = serviceUrl.replace("://", "://%s." + zone + ".");
            if ((objectName = QSStringUtil.asciiCharactersEncoding(objectName)) != null && objectName.indexOf("?") > 0) {
                return String.format(String.valueOf(storRequestUrl) + "/%s&access_key_id=%s&expires=%s&signature=%s", bucketName, objectName, evnContext.getAccessKey(), "" + expiresTime, expireAuth);
            }
            return String.format(String.valueOf(storRequestUrl) + "/%s?access_key_id=%s&expires=%s&signature=%s", bucketName, objectName, evnContext.getAccessKey(), "" + expiresTime, expireAuth);
        }
        throw new QSException("ExpiresRequestUrl error:There is no expirs params");
    }

    private String getSignature() throws QSException {
        Object signature = this.paramsHeaders.get("Authorization");
        if (signature == null) {
            this.doSignature();
            return String.valueOf(this.paramsHeaders.get("Authorization"));
        }
        return String.valueOf(signature);
    }
}

