/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.request;

import com.qingstor.sdk.constants.QSConstant;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.request.ResponseCallBack;
import com.qingstor.sdk.utils.QSJSONUtil;
import com.qingstor.sdk.utils.QSLoggerUtil;
import com.qingstor.sdk.utils.QSParamInvokeUtil;
import com.qingstor.sdk.utils.QSStringUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpMethod;
import okio.BufferedSink;
import org.json.JSONObject;

public class QSOkHttpRequestClient {
    private static Logger logger = QSLoggerUtil.setLoggerHanlder(QSOkHttpRequestClient.class.getName());
    private OkHttpClient client = null;
    private OkHttpClient unsafeClient = null;
    private static volatile QSOkHttpRequestClient ins;

    protected QSOkHttpRequestClient() {
        this.intiOkHttpClient();
    }

    public void intiOkHttpClient() {
        this.client = new OkHttpClient.Builder().connectTimeout((long)QSConstant.HTTPCLIENT_CONNECTION_TIME_OUT, TimeUnit.SECONDS).readTimeout((long)QSConstant.HTTPCLIENT_READ_TIME_OUT, TimeUnit.SECONDS).writeTimeout((long)QSConstant.HTTPCLIENT_WRITE_TIME_OUT, TimeUnit.SECONDS).build();
        this.unsafeClient = QSOkHttpRequestClient.getUnsafeOkHttpClient();
    }

    @Deprecated
    private static OkHttpClient getUnsafeOkHttpClient() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout((long)QSConstant.HTTPCLIENT_CONNECTION_TIME_OUT, TimeUnit.SECONDS).readTimeout((long)QSConstant.HTTPCLIENT_READ_TIME_OUT, TimeUnit.SECONDS).writeTimeout((long)QSConstant.HTTPCLIENT_WRITE_TIME_OUT, TimeUnit.SECONDS);
            builder.sslSocketFactory(sslSocketFactory);
            builder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            OkHttpClient okHttpClient = builder.build();
            return okHttpClient;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage());
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QSOkHttpRequestClient getInstance() {
        if (ins != null) return ins;
        Class<QSOkHttpRequestClient> clazz = QSOkHttpRequestClient.class;
        synchronized (QSOkHttpRequestClient.class) {
            if (ins != null) return ins;
            ins = new QSOkHttpRequestClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ins;
        }
    }

    private Call getRequestCall(boolean bSafe, Request request) {
        if (bSafe) {
            return this.client.newCall(request);
        }
        return this.unsafeClient.newCall(request);
    }

    public OutputModel requestAction(Request request, boolean bSafe, Class outputClass) throws QSException {
        Call okhttpCall = this.getRequestCall(bSafe, request);
        Response response = null;
        try {
            OutputModel model = (OutputModel)QSParamInvokeUtil.getOutputModel(outputClass);
            response = okhttpCall.execute();
            this.fillResponseValue2Object(response, model);
            return model;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage());
            throw new QSException(e.getMessage());
        }
    }

    public Request buildUrlRequest(String singedUrl) {
        Request request = new Request.Builder().url(singedUrl).build();
        return request;
    }

    public OutputModel requestActionAsync(Request request, boolean bSafe, final ResponseCallBack callBack) throws QSException {
        Call okhttpCall = this.getRequestCall(bSafe, request);
        okhttpCall.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                QSOkHttpRequestClient.this.onOkhttpFailure(e.getMessage(), callBack);
            }

            public void onResponse(Call call, Response response) throws IOException {
                try {
                    try {
                        if (callBack != null) {
                            OutputModel m = QSParamInvokeUtil.getOutputModel(callBack);
                            QSOkHttpRequestClient.this.fillResponseValue2Object(response, m);
                            callBack.onAPIResponse(m);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage());
                        QSOkHttpRequestClient.this.onOkhttpFailure(e.getMessage(), callBack);
                        if (response != null) {
                            Util.closeQuietly((Closeable)response.body().source());
                        }
                    }
                }
                finally {
                    if (response != null) {
                        Util.closeQuietly((Closeable)response.body().source());
                    }
                }
            }
        });
        return null;
    }

    private void onOkhttpFailure(String message, ResponseCallBack callBack) {
        try {
            if (callBack != null) {
                OutputModel m = QSParamInvokeUtil.getOutputModel(callBack);
                QSOkHttpRequestClient.fillResponseCallbackModel(10000, message, m);
                callBack.onAPIResponse(m);
            }
        }
        catch (Exception ee) {
            logger.log(Level.SEVERE, ee.getMessage());
        }
    }

    private void fillResponseValue2Object(Response response, OutputModel target) throws IOException {
        int code = response.code();
        ResponseBody body = response.body();
        JSONObject o = QSJSONUtil.toJSONObject("{}");
        QSJSONUtil.putJsonData(o, "BodyInputStream", (Object)body.source().inputStream());
        if (target != null) {
            if (!QSJSONUtil.jsonObjFillValue2Object(o, target)) {
                try {
                    String responseInfo = body.string();
                    if (!QSStringUtil.isEmpty(responseInfo)) {
                        QSJSONUtil.jsonFillValue2Object(responseInfo, target);
                    }
                }
                catch (Exception responseInfo) {
                    // empty catch block
                }
            }
            Headers responceHeaders = response.headers();
            int iHeads = responceHeaders.size();
            JSONObject headJson = QSJSONUtil.toJSONObject("{}");
            QSJSONUtil.putJsonData(headJson, QSConstant.QC_CODE_FIELD_NAME, (Object)code);
            int i = 0;
            while (i < iHeads) {
                QSJSONUtil.putJsonData(headJson, responceHeaders.name(i), (Object)responceHeaders.value(i));
                ++i;
            }
            QSJSONUtil.jsonObjFillValue2Object(headJson, target);
        }
    }

    public Request buildStorRequest(String method, Map bodyContent, String signedUrl, Map headParams) throws QSException {
        String[] sortedHeadersKeys;
        Request.Builder builder = new Request.Builder();
        Request request = null;
        String[] stringArray = sortedHeadersKeys = headParams.keySet().toArray(new String[0]);
        int n = sortedHeadersKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            builder.addHeader(key, "" + headParams.get(key));
            ++n2;
        }
        if (!headParams.containsKey("User-Agent")) {
            builder.addHeader("User-Agent", QSStringUtil.getUserAgent());
        }
        String contentType = "" + headParams.get("Content-Type");
        MediaType mediaType = MediaType.parse((String)contentType);
        if (bodyContent != null && bodyContent.size() > 0) {
            RequestBody body = null;
            Object bodyObj = this.getBodyContent(bodyContent);
            if (bodyObj instanceof String) {
                body = RequestBody.create((MediaType)mediaType, (String)bodyObj.toString());
            } else if (bodyObj instanceof File) {
                body = RequestBody.create((MediaType)mediaType, (File)((File)bodyObj));
            } else if (bodyObj instanceof InputStream) {
                long contentLength = 0L;
                if (headParams.containsKey("Content-Length")) {
                    contentLength = Long.parseLong("" + headParams.get("Content-Length"));
                }
                body = new InputStreamUploadBody(contentType, (InputStream)bodyObj, contentLength);
            }
            request = builder.url(signedUrl).method(method, body).build();
        } else {
            request = HttpMethod.permitsRequestBody((String)method) ? builder.url(signedUrl).method(method, (RequestBody)new EmptyRequestBody(contentType)).build() : builder.url(signedUrl).method(method, null).build();
        }
        return request;
    }

    public Object getBodyContent(Map bodyContent) {
        for (Map.Entry entry : bodyContent.entrySet()) {
            String key = (String)entry.getKey();
            Object bodyObj = bodyContent.get(key);
            if (!"BodyInputFile".equals(key) && !"BodyInputStream".equals(key) && !"BodyInput".equals(key)) continue;
            return bodyObj;
        }
        String jsonStr = QSStringUtil.getObjectToJson(bodyContent);
        return jsonStr;
    }

    public Request buildStorMultiUpload(String method, Map bodyContent, String singedUrl, Map headParams, Map queryParams) throws QSException {
        String[] sortedHeadersKeys;
        Request.Builder builder = new Request.Builder();
        String[] stringArray = sortedHeadersKeys = headParams.keySet().toArray(new String[0]);
        int n = sortedHeadersKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            builder.addHeader(key, "" + headParams.get(key));
            ++n2;
        }
        if (!headParams.containsKey("User-Agent")) {
            builder.addHeader("User-Agent", QSStringUtil.getUserAgent());
        }
        if (bodyContent != null && bodyContent.size() > 0) {
            String contentType = "" + headParams.get("Content-Type");
            MediaType mediaType = MediaType.parse((String)contentType);
            RequestBody requestBody = null;
            Iterator iterator = bodyContent.entrySet().iterator();
            int contentLength = Integer.parseInt("" + headParams.get("Content-Length"));
            int partNumber = Integer.parseInt("" + queryParams.get("part_number"));
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String key = (String)entry.getKey();
                Object bodyObj = bodyContent.get(key);
                if (bodyObj instanceof String) {
                    requestBody = RequestBody.create((MediaType)mediaType, (String)bodyObj.toString());
                    continue;
                }
                if (bodyObj instanceof File) {
                    RandomAccessFile rFile = null;
                    try {
                        rFile = new RandomAccessFile((File)bodyObj, "r");
                        rFile.seek(contentLength * partNumber);
                        long contentLeft = ((File)bodyObj).length() - (long)(contentLength * (partNumber + 1));
                        int readContentLength = contentLength;
                        if (contentLeft < 0L) {
                            readContentLength = (readContentLength = (int)((long)readContentLength + contentLeft)) > 0 ? readContentLength : 0;
                        }
                        requestBody = new MulitFileuploadBody(contentType, rFile, readContentLength);
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new QSException(e.getMessage());
                    }
                }
                if (bodyObj instanceof InputStream) {
                    requestBody = new InputStreamUploadBody(contentType, (InputStream)bodyObj, contentLength);
                    continue;
                }
                String jsonStr = QSStringUtil.objectToJson(key, bodyObj);
                requestBody = RequestBody.create((MediaType)mediaType, (String)jsonStr);
            }
            if (requestBody != null) {
                builder.method(method, requestBody);
            }
        }
        Request request = builder.url(singedUrl).build();
        return request;
    }

    public static void fillResponseCallbackModel(int code, Object content, OutputModel model) {
        HashMap<String, Object> errorMap = new HashMap<String, Object>();
        errorMap.put(QSConstant.QC_CODE_FIELD_NAME, code);
        errorMap.put(QSConstant.QC_MESSAGE_FIELD_NAME, content);
        QSJSONUtil.jsonFillValue2Object(QSStringUtil.getObjectToJson(errorMap), model);
    }

    private static class EmptyRequestBody
    extends RequestBody {
        private String contentType;
        private int contentLength = 0;

        public EmptyRequestBody(String contentType) {
            this.contentType = contentType;
        }

        public long contentLength() throws IOException {
            return this.contentLength;
        }

        public void writeTo(BufferedSink sink) throws IOException {
        }

        public MediaType contentType() {
            return MediaType.parse((String)this.contentType);
        }
    }

    private static class InputStreamUploadBody
    extends RequestBody {
        private String contentType;
        private long contentLength;
        private InputStream file;

        public InputStreamUploadBody(String contentType, InputStream rFile, long contentLength) {
            this.contentLength = contentLength;
            this.contentType = contentType;
            this.file = rFile;
        }

        public long contentLength() throws IOException {
            return this.contentLength;
        }

        public MediaType contentType() {
            return MediaType.parse((String)this.contentType);
        }

        public void writeTo(BufferedSink sink) throws IOException {
            int readSize = 1024;
            int bytes = 0;
            byte[] bufferOut = new byte[readSize];
            long count = this.contentLength / (long)readSize;
            long leftCount = this.contentLength % (long)readSize;
            long iReadLength = 0L;
            while (count > 0L && (bytes = this.file.read(bufferOut)) != -1) {
                sink.write(bufferOut, 0, bytes);
                --count;
                iReadLength += (long)bytes;
                if (bytes == readSize) continue;
                count = (this.contentLength - iReadLength) / (long)readSize;
                leftCount = (this.contentLength - iReadLength) % (long)readSize;
            }
            if (count == 0L && leftCount > 0L && (bytes = this.file.read(bufferOut = new byte[(int)leftCount])) != -1) {
                sink.write(bufferOut, 0, bytes);
            }
            Util.closeQuietly((Closeable)this.file);
        }
    }

    private static class MulitFileuploadBody
    extends RequestBody {
        private String contentType;
        private int contentLength;
        private RandomAccessFile file;

        public MulitFileuploadBody(String contentType, RandomAccessFile rFile, int contentLength) {
            this.contentLength = contentLength;
            this.contentType = contentType;
            this.file = rFile;
        }

        public long contentLength() throws IOException {
            return this.contentLength;
        }

        public MediaType contentType() {
            return MediaType.parse((String)this.contentType);
        }

        public void writeTo(BufferedSink sink) throws IOException {
            int readSize = 1024;
            int bytes = 0;
            byte[] bufferOut = new byte[readSize];
            int count = this.contentLength / readSize;
            int leftCount = this.contentLength % readSize;
            while (count > 0 && (bytes = this.file.read(bufferOut)) != -1) {
                sink.write(bufferOut, 0, bytes);
                --count;
            }
            if (count >= 0 && leftCount > 0 && (bytes = this.file.read(bufferOut = new byte[leftCount])) != -1) {
                sink.write(bufferOut, 0, bytes);
            }
            Util.closeQuietly((Closeable)this.file);
        }
    }
}

