/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.service;

import com.qingstor.sdk.annotation.ParamAnnotation;
import com.qingstor.sdk.config.EvnContext;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.model.RequestInputModel;
import com.qingstor.sdk.request.RequestHandler;
import com.qingstor.sdk.request.ResourceRequestFactory;
import com.qingstor.sdk.request.ResponseCallBack;
import com.qingstor.sdk.service.Bucket;
import com.qingstor.sdk.service.Types;
import java.util.HashMap;
import java.util.List;

public class QingStor {
    private String zone;
    private EvnContext evnContext;
    private String bucketName;

    public QingStor(EvnContext evnContext) {
        this(evnContext, "pek3a");
    }

    public QingStor(EvnContext evnContext, String zone) {
        this.evnContext = evnContext;
        this.zone = zone;
    }

    public ListBucketsOutput listBuckets(ListBucketsInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new ListBucketsInput();
        }
        if ((backModel = (requestHandler = this.listBucketsRequest(input)).send()) != null) {
            return (ListBucketsOutput)backModel;
        }
        return null;
    }

    public RequestHandler listBucketsRequest(ListBucketsInput input) throws QSException {
        if (input == null) {
            input = new ListBucketsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.evnContext);
        context.put("OperationName", "ListBuckets");
        context.put("APIName", "ListBuckets");
        context.put("ServiceName", "Get Service");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/");
        context.put("bucketNameInput", this.bucketName);
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, ListBucketsOutput.class);
        return requestHandler;
    }

    public void listBucketsAsync(ListBucketsInput input, ResponseCallBack<ListBucketsOutput> callback) throws QSException {
        if (input == null) {
            input = new ListBucketsInput();
        }
        RequestHandler requestHandler = this.listBucketsAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler listBucketsAsyncRequest(ListBucketsInput input, ResponseCallBack<ListBucketsOutput> callback) throws QSException {
        if (input == null) {
            input = new ListBucketsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.evnContext);
        context.put("OperationName", "ListBuckets");
        context.put("APIName", "ListBuckets");
        context.put("ServiceName", "Get Service");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/");
        context.put("bucketNameInput", this.bucketName);
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    @Deprecated
    public Bucket getBucket(String bucketName) {
        return new Bucket(this.evnContext, this.zone, bucketName);
    }

    public Bucket getBucket(String bucketName, String zone) {
        return new Bucket(this.evnContext, zone, bucketName);
    }

    public static class ListBucketsInput
    extends RequestInputModel {
        private String location;

        public void setLocation(String location) {
            this.location = location;
        }

        @ParamAnnotation(paramType="header", paramName="Location")
        public String getLocation() {
            return this.location;
        }

        @Override
        public String validateParam() {
            return null;
        }
    }

    public static class ListBucketsOutput
    extends OutputModel {
        private List<Types.BucketModel> buckets;
        private Long count;

        public void setBuckets(List<Types.BucketModel> buckets) {
            this.buckets = buckets;
        }

        @ParamAnnotation(paramType="query", paramName="buckets")
        public List<Types.BucketModel> getBuckets() {
            return this.buckets;
        }

        public void setCount(Long count) {
            this.count = count;
        }

        @ParamAnnotation(paramType="query", paramName="count")
        public Long getCount() {
            return this.count;
        }
    }
}

