/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.utils;

import com.qingstor.sdk.annotation.ParamAnnotation;
import com.qingstor.sdk.utils.QSParamInvokeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class QSJSONUtil {
    public static Map<String, Object> jsonToMap(JSONObject json) throws JSONException {
        Map<String, Object> retMap = new HashMap<String, Object>();
        if (json != JSONObject.NULL) {
            retMap = QSJSONUtil.toMap(json);
        }
        return retMap;
    }

    public static Map<String, Object> toMap(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Iterator keysItr = object.keys();
            while (keysItr.hasNext()) {
                String key = (String)keysItr.next();
                List<Object> value = object.get(key);
                if (value instanceof JSONArray) {
                    value = QSJSONUtil.toList((JSONArray)value);
                } else if (value instanceof JSONObject) {
                    value = QSJSONUtil.toMap((JSONObject)value);
                }
                if (value == null) continue;
                map.put(key, value);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static List<Object> toList(JSONArray array) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            int i = 0;
            int cnt = array.length();
            while (i < cnt) {
                List<Object> value = array.get(i);
                if (value instanceof JSONArray) {
                    value = QSJSONUtil.toList((JSONArray)value);
                } else if (value instanceof JSONObject) {
                    value = QSJSONUtil.toMap((JSONObject)value);
                }
                list.add(value);
                ++i;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static String toString(JSONObject object, String key) {
        String rst = "";
        if (object == null || object.isNull(key)) {
            return rst;
        }
        try {
            rst = object.getString(key);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return rst;
    }

    public static Double toDouble(JSONArray labelDatas, int i) {
        if (labelDatas == null || labelDatas.length() <= i) {
            return 0.0;
        }
        double rst = 0.0;
        try {
            rst = labelDatas.getDouble(i);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return rst;
    }

    public static Object toObject(JSONArray labelDatas, int i) {
        if (labelDatas == null || labelDatas.length() <= i) {
            return null;
        }
        Object rst = null;
        try {
            rst = labelDatas.get(i);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return rst;
    }

    public static Object toObject(JSONObject labelDatas, String key) {
        if (labelDatas == null || labelDatas.isNull(key)) {
            return null;
        }
        Object rst = null;
        try {
            rst = labelDatas.get(key);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return rst;
    }

    public static boolean toBoolean(JSONObject object, String key) {
        if (object == null || object.isNull(key)) {
            return false;
        }
        boolean rst = false;
        try {
            rst = object.getBoolean(key);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return rst;
    }

    public static int toInt(JSONObject object, String key) {
        int i = -1;
        try {
            i = object.getInt(key);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return i;
    }

    public static double toDouble(JSONObject object, String key) {
        double i = -1.0;
        try {
            i = object.getDouble(key);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return i;
    }

    public static List toList(JSONObject obj, String key) {
        if (obj == null || obj.isNull(key)) {
            return null;
        }
        ArrayList<Object> llist = new ArrayList<Object>();
        try {
            JSONArray array = obj.getJSONArray(key);
            int i = 0;
            int c = array.length();
            while (i < c) {
                llist.add(array.get(i));
                ++i;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return llist;
    }

    public static JSONArray toJSONArray(JSONObject obj, String key) {
        JSONArray res = null;
        if (obj == null || obj.isNull(key)) {
            return null;
        }
        try {
            res = obj.getJSONArray(key);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static Object toJSONObject(JSONObject obj, int index) {
        Object res = null;
        if (obj == null || obj.length() < index) {
            return null;
        }
        Iterator it = obj.keys();
        int i = 0;
        while (it.hasNext()) {
            if (index == i) {
                String key = (String)it.next();
                return QSJSONUtil.toObject(obj, key);
            }
            ++i;
        }
        return res;
    }

    public static String toJSONkey(JSONObject obj, int index) {
        String key = null;
        if (obj == null || obj.length() < index) {
            return null;
        }
        Iterator it = obj.keys();
        int i = 0;
        while (it.hasNext()) {
            if (index == i) {
                key = (String)it.next();
            } else {
                it.next();
            }
            ++i;
        }
        return key;
    }

    public static JSONArray toJSONArray(JSONArray obj, int i) {
        JSONArray res = null;
        if (obj.length() > i) {
            try {
                res = obj.getJSONArray(i);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    public static JSONObject toJSONObject(String str) {
        JSONObject obj = null;
        try {
            if (str != null) {
                obj = new JSONObject(str);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static JSONObject toJSONObject(JSONObject jsonArray, String key) {
        JSONObject res = null;
        if (jsonArray == null || jsonArray.isNull(key)) {
            return null;
        }
        try {
            res = jsonArray.getJSONObject(key);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static int toJSONInt(JSONArray jsonArray, int index) {
        int obj = 0;
        if (jsonArray == null || jsonArray.length() <= index) {
            return obj;
        }
        try {
            obj = jsonArray.getInt(index);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static void putJsonData(JSONObject jsonObject, String key, Object value) {
        if (jsonObject != null) {
            try {
                jsonObject.put(key, value);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public static void putJsonData(JSONArray jsonObject, int index, Object value) {
        if (jsonObject != null) {
            try {
                jsonObject.put(index, value);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public static String toJSONString(JSONArray jsonArray, int index) {
        String obj = "";
        if (jsonArray == null || jsonArray.length() <= index) {
            return obj;
        }
        try {
            obj = jsonArray.getString(index);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static JSONObject toJSONObject(JSONArray jsonArray, int index) {
        JSONObject obj = null;
        if (jsonArray == null) {
            return null;
        }
        try {
            obj = jsonArray.getJSONObject(index);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static List sortJSONArray(JSONArray array) {
        LinkedList<String> llist = new LinkedList<String>();
        try {
            int i = 0;
            int c = array.length();
            while (i < c) {
                llist.add(array.getString(i));
                ++i;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Collections.sort(llist, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s2.compareToIgnoreCase(s1);
            }
        });
        return llist;
    }

    public static void sortJSONArray(List array, final String key) {
        Collections.sort(array, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                String v1 = QSJSONUtil.toString(o1, key);
                String v2 = QSJSONUtil.toString(o2, key);
                if (v2 == null) {
                    v2 = "";
                }
                if (v1 == null) {
                    v1 = "";
                }
                return v2.compareToIgnoreCase(v1);
            }
        });
    }

    public static void sortJSONArrayAscending(List array, final String key) {
        Collections.sort(array, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                String v1 = QSJSONUtil.toString(o1, key);
                String v2 = QSJSONUtil.toString(o2, key);
                return v1.compareToIgnoreCase(v2);
            }
        });
    }

    public static JSONObject convertJSONObject(String string) {
        JSONObject obj = null;
        try {
            obj = new JSONObject(string);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static void responceFillValue2Object(Response response, Object targetObj) {
    }

    public static boolean jsonFillValue2Object(String jsonStr, Object targetObj) {
        JSONObject o = QSJSONUtil.toJSONObject(jsonStr);
        return QSJSONUtil.jsonObjFillValue2Object(o, targetObj);
    }

    public static boolean jsonObjFillValue2Object(JSONObject o, Object targetObj) {
        boolean hasParam = false;
        if (targetObj != null) {
            try {
                Class<?> tmpClass = targetObj.getClass();
                while (tmpClass != Object.class) {
                    Field[] fields = tmpClass.getDeclaredFields();
                    if (QSJSONUtil.initParameter(o, fields, tmpClass, targetObj)) {
                        hasParam = true;
                    }
                    tmpClass = tmpClass.getSuperclass();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return hasParam;
    }

    private static boolean initParameter(JSONObject o, Field[] declaredField, Class objClass, Object targetObj) throws NoSuchMethodException {
        boolean hasParam = false;
        Field[] fieldArray = declaredField;
        int n = declaredField.length;
        int n2 = 0;
        while (n2 < n) {
            Method[] methods;
            Field field = fieldArray[n2];
            String methodField = QSParamInvokeUtil.capitalize(field.getName());
            String getMethodName = field.getType() == Boolean.class ? "is" + methodField : "get" + methodField;
            String setMethodName = "set" + methodField;
            Method[] methodArray = methods = objClass.getDeclaredMethods();
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                String dataKey;
                ParamAnnotation annotation;
                Method m = methodArray[n4];
                if (m.getName().equals(getMethodName) && (annotation = m.getAnnotation(ParamAnnotation.class)) != null && o.has(dataKey = annotation.paramName())) {
                    hasParam = true;
                    Object data = QSJSONUtil.toObject(o, dataKey);
                    Method setM = objClass.getDeclaredMethod(setMethodName, field.getType());
                    QSJSONUtil.setParameterToMap(setM, targetObj, field, data);
                }
                ++n4;
            }
            ++n2;
        }
        return hasParam;
    }

    private static void setParameterToMap(Method m, Object source, Field f, Object data) {
        block19: {
            if (data != null) {
                try {
                    if (data instanceof JSONArray || data instanceof JSONObject) {
                        Class<?> fClass = f.getType();
                        if (fClass.equals(List.class)) {
                            ArrayList<Object> invokeData = new ArrayList<Object>();
                            ParameterizedType stringListType = (ParameterizedType)f.getGenericType();
                            Class cls = (Class)stringListType.getActualTypeArguments()[0];
                            if (cls.equals(String.class) || cls.equals(Integer.class) || cls.equals(Double.class) || cls.equals(Long.class) || cls.equals(Float.class)) {
                                if (data instanceof JSONArray) {
                                    JSONArray jsonData = (JSONArray)data;
                                    int i = 0;
                                    while (i < jsonData.length()) {
                                        Object o = QSJSONUtil.toObject(jsonData, i);
                                        invokeData.add(o);
                                        ++i;
                                    }
                                }
                            } else if (data instanceof JSONArray) {
                                JSONArray jsonData = (JSONArray)data;
                                int i = 0;
                                while (i < jsonData.length()) {
                                    Object fObject = cls.newInstance();
                                    JSONObject o = QSJSONUtil.toJSONObject(jsonData, i);
                                    Class<?> tmpClass = fObject.getClass();
                                    while (tmpClass != Object.class) {
                                        Field[] fields = tmpClass.getDeclaredFields();
                                        QSJSONUtil.initParameter(o, fields, tmpClass, fObject);
                                        tmpClass = tmpClass.getSuperclass();
                                    }
                                    invokeData.add(fObject);
                                    ++i;
                                }
                            }
                            m.invoke(source, invokeData);
                            break block19;
                        }
                        if (fClass.equals(Map.class)) {
                            HashMap<String, JSONObject> invokeData = new HashMap<String, JSONObject>();
                            if (data instanceof JSONObject) {
                                JSONObject jsonData = (JSONObject)data;
                                int i = 0;
                                while (i < jsonData.length()) {
                                    String key = "" + QSJSONUtil.toJSONObject(jsonData, i);
                                    JSONObject value = QSJSONUtil.toJSONObject(jsonData, key);
                                    invokeData.put(key, value);
                                    ++i;
                                }
                            }
                            m.invoke(source, invokeData);
                        } else {
                            Object invokeData = f.getType().newInstance();
                            Class<?> tmpClass = invokeData.getClass();
                            while (tmpClass != Object.class) {
                                Field[] fields = tmpClass.getDeclaredFields();
                                QSJSONUtil.initParameter((JSONObject)data, fields, tmpClass, invokeData);
                                tmpClass = tmpClass.getSuperclass();
                            }
                            m.invoke(source, invokeData);
                        }
                        break block19;
                    }
                    if (f.getType().equals(data.getClass())) {
                        m.invoke(source, data);
                    } else {
                        m.invoke(source, QSJSONUtil.getParseValue(f.getType(), data));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static Object getParseValue(Class type, Object value) {
        if (String.class.equals((Object)type)) {
            return value.toString();
        }
        if (Integer.class.equals((Object)type) || "int".equals(type.toString())) {
            return Integer.parseInt(value.toString());
        }
        if (Double.class.equals((Object)type) || "double".equals(type.toString())) {
            return Double.parseDouble(value.toString());
        }
        if (Long.class.equals((Object)type) || "long".equals(type.toString())) {
            return Long.parseLong(value.toString());
        }
        if (Float.class.equals((Object)type) || "float".equals(type.toString())) {
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        return value;
    }
}

