/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.utils;

import com.qingstor.sdk.annotation.ParamAnnotation;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.request.ResponseCallBack;
import com.qingstor.sdk.utils.QSSignatureUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QSParamInvokeUtil {
    public static Map getRequestParams(Object model, String paramType) {
        HashMap<String, String> retParametersMap = new HashMap<String, String>();
        if (model != null) {
            try {
                Class<?> tmpClass = model.getClass();
                while (tmpClass != Object.class) {
                    QSParamInvokeUtil.initParameterMap(tmpClass, model, retParametersMap, paramType);
                    tmpClass = tmpClass.getSuperclass();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ("header".equals(paramType) && !retParametersMap.containsKey("Date")) {
            retParametersMap.put("Date", QSSignatureUtil.formatGmtDate(new Date()));
        }
        return retParametersMap;
    }

    private static void initParameterMap(Class objClass, Object source, Map retParametersMap, String paramType) throws InvocationTargetException, IllegalAccessException, QSException {
        Field[] declaredField;
        Field[] fieldArray = declaredField = objClass.getDeclaredFields();
        int n = declaredField.length;
        int n2 = 0;
        while (n2 < n) {
            Method[] methods;
            Field field = fieldArray[n2];
            String methodName = "get" + QSParamInvokeUtil.capitalize(field.getName());
            String fieldName = field.getName();
            Method[] methodArray = methods = objClass.getDeclaredMethods();
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                ParamAnnotation annotation;
                Method m = methodArray[n4];
                if (m.getName().equalsIgnoreCase(methodName) && (annotation = m.getAnnotation(ParamAnnotation.class)) != null) {
                    if (!"".equals(annotation.paramName())) {
                        fieldName = annotation.paramName();
                    }
                    if (paramType.equals(annotation.paramType())) {
                        QSParamInvokeUtil.setParameterToMap(m, source, retParametersMap, fieldName);
                    } else if (paramType.equals(annotation.paramType())) {
                        QSParamInvokeUtil.setParameterToMap(m, source, retParametersMap, fieldName);
                    } else if (paramType.equals(annotation.paramType())) {
                        QSParamInvokeUtil.setParameterToMap(m, source, retParametersMap, fieldName);
                    } else if ("".equals(paramType)) {
                        QSParamInvokeUtil.setParameterToMap(m, source, retParametersMap, fieldName);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void setParameterToMap(Method m, Object source, Map retParametersMap, String paramKey) throws InvocationTargetException, IllegalAccessException, QSException {
        Object[] invokeParams = null;
        Object objValue = m.invoke(source, invokeParams);
        if (objValue != null) {
            Class<?> cls = objValue.getClass();
            if (cls.equals(Integer.class) || cls.equals(Double.class) || cls.equals(Boolean.class) || cls.equals(Long.class) || cls.equals(Float.class)) {
                retParametersMap.put(paramKey, "" + objValue);
            } else if (cls.equals(String.class)) {
                retParametersMap.put(paramKey, objValue);
            } else {
                retParametersMap.put(paramKey, objValue);
            }
        }
    }

    public static String capitalize(String word) {
        return String.valueOf(word.substring(0, 1).toUpperCase()) + word.substring(1);
    }

    public static Object getOutputModel(Class className) throws QSException {
        try {
            return className.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new QSException(e.getMessage());
        }
    }

    public static Map serializeParams(Map parameters) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : parameters.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                int i = 0;
                int cnt = ((List)value).size();
                while (i < cnt) {
                    Object v2 = ((List)value).get(i);
                    if (v2 instanceof Map) {
                        for (Object key2 : ((Map)v2).keySet()) {
                            result.put(String.valueOf(key) + "." + String.valueOf(i + 1) + "." + key2, ((Map)v2).get(key2));
                        }
                    } else {
                        result.put(String.valueOf(key) + "." + String.valueOf(i + 1), v2);
                    }
                    ++i;
                }
                continue;
            }
            if (value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Boolean) {
                result.put(key, String.valueOf(value));
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    public static OutputModel getOutputModel(ResponseCallBack o) throws QSException {
        Type[] typeClass = o.getClass().getGenericInterfaces();
        try {
            if (typeClass[0] instanceof ParameterizedType) {
                Class actualType = (Class)((ParameterizedType)typeClass[0]).getActualTypeArguments()[0];
                return (OutputModel)actualType.newInstance();
            }
            return (OutputModel)OutputModel.class.newInstance();
        }
        catch (InstantiationException e) {
            throw new QSException("InstantiationException", e);
        }
        catch (IllegalAccessException e) {
            throw new QSException("IllegalAccessException", e);
        }
    }
}

